/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.plugins.diskpersistence;

import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import com.opensymphony.oscache.plugins.diskpersistence.AbstractDiskPersistenceListener;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashDiskPersistenceListener
extends AbstractDiskPersistenceListener {
    protected static final String HASH_ALGORITHM_KEY = "cache.persistence.disk.hash.algorithm";
    public static final String DEFAULT_HASH_ALGORITHM = "MD5";
    protected MessageDigest md = null;

    public PersistenceListener configure(Config config) {
        try {
            if (config.getProperty(HASH_ALGORITHM_KEY) != null) {
                try {
                    this.md = MessageDigest.getInstance(config.getProperty(HASH_ALGORITHM_KEY));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.md = MessageDigest.getInstance(DEFAULT_HASH_ALGORITHM);
                }
            } else {
                this.md = MessageDigest.getInstance(DEFAULT_HASH_ALGORITHM);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new RuntimeException("No hash algorithm available for disk persistence", noSuchAlgorithmException);
        }
        return super.configure(config);
    }

    protected char[] getCacheFileName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid key '" + string + "' specified to getCacheFile.");
        }
        byte[] byArray = this.md.digest(string.getBytes());
        String string2 = HashDiskPersistenceListener.byteArrayToHexString(byArray);
        return string2.toCharArray();
    }

    static String byteArrayToHexString(byte[] byArray) {
        byte by = 0;
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(byArray[i] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(stringArray[by]);
            by = (byte)(byArray[i] & 0xF);
            stringBuffer.append(stringArray[by]);
        }
        String string = new String(stringBuffer);
        return string;
    }
}

