/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.plugins.diskpersistence;

import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDiskPersistenceListener
implements PersistenceListener,
Serializable {
    protected static final String CACHE_PATH_KEY = "cache.path";
    protected static final String CACHE_EXTENSION = "cache";
    protected static final String GROUP_DIRECTORY = "__groups__";
    protected static final String APPLICATION_CACHE_SUBPATH = "application";
    protected static final String SESSION_CACHE_SUBPATH = "session";
    protected static final String CONTEXT_TMPDIR = "javax.servlet.context.tempdir";
    private static final transient Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$plugins$diskpersistence$AbstractDiskPersistenceListener == null ? (class$com$opensymphony$oscache$plugins$diskpersistence$AbstractDiskPersistenceListener = AbstractDiskPersistenceListener.class$("com.opensymphony.oscache.plugins.diskpersistence.AbstractDiskPersistenceListener")) : class$com$opensymphony$oscache$plugins$diskpersistence$AbstractDiskPersistenceListener));
    private File cachePath = null;
    private File contextTmpDir;
    private String root = null;
    static /* synthetic */ Class class$com$opensymphony$oscache$plugins$diskpersistence$AbstractDiskPersistenceListener;

    public File getCachePath() {
        return this.cachePath;
    }

    public String getRoot() {
        return this.root;
    }

    public File getContextTmpDir() {
        return this.contextTmpDir;
    }

    public boolean isGroupStored(String string) throws CachePersistenceException {
        try {
            File file = this.getCacheGroupFile(string);
            return file.exists();
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable verify group '" + string + "' exists in the cache: " + exception);
        }
    }

    public boolean isStored(String string) throws CachePersistenceException {
        try {
            File file = this.getCacheFile(string);
            return file.exists();
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable verify id '" + string + "' is stored in the cache: " + exception);
        }
    }

    public void clear() throws CachePersistenceException {
        this.clear(this.root);
    }

    public PersistenceListener configure(Config config) {
        String string = null;
        int n = 0;
        this.initFileCaching(config.getProperty(CACHE_PATH_KEY));
        if (config.getProperty("sessionId") != null) {
            string = config.getProperty("sessionId");
        }
        if (config.getProperty("scope") != null) {
            n = Integer.parseInt(config.getProperty("scope"));
        }
        StringBuffer stringBuffer = new StringBuffer(this.getCachePath().getPath());
        stringBuffer.append("/");
        stringBuffer.append(this.getPathPart(n));
        if (string != null && string.length() > 0) {
            stringBuffer.append("/");
            stringBuffer.append(string);
        }
        this.root = stringBuffer.toString();
        this.contextTmpDir = (File)config.get("context.tempdir");
        return this;
    }

    public void remove(String string) throws CachePersistenceException {
        File file = this.getCacheFile(string);
        this.remove(file);
    }

    public void removeGroup(String string) throws CachePersistenceException {
        File file = this.getCacheGroupFile(string);
        this.remove(file);
    }

    public Object retrieve(String string) throws CachePersistenceException {
        return this.retrieve(this.getCacheFile(string));
    }

    public Set retrieveGroup(String string) throws CachePersistenceException {
        File file = this.getCacheGroupFile(string);
        try {
            return (Set)this.retrieve(file);
        }
        catch (ClassCastException classCastException) {
            throw new CachePersistenceException("Group file " + file + " was not persisted as a Set: " + classCastException);
        }
    }

    public void store(String string, Object object) throws CachePersistenceException {
        File file = this.getCacheFile(string);
        this.store(file, object);
    }

    public void storeGroup(String string, Set set) throws CachePersistenceException {
        File file = this.getCacheGroupFile(string);
        this.store(file, (Object)set);
    }

    protected String adjustFileCachePath(String string) {
        if (string.compareToIgnoreCase(CONTEXT_TMPDIR) == 0) {
            string = this.contextTmpDir.getAbsolutePath();
        }
        return string;
    }

    protected void initFileCaching(String string) {
        if (string != null) {
            this.cachePath = new File(string);
            try {
                if (!this.cachePath.exists()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("cache.path '" + string + "' does not exist, creating"));
                    }
                    this.cachePath.mkdirs();
                }
                if (!this.cachePath.isDirectory()) {
                    log.error((Object)("cache.path '" + string + "' is not a directory"));
                    this.cachePath = null;
                } else if (!this.cachePath.canWrite()) {
                    log.error((Object)("cache.path '" + string + "' is not a writable location"));
                    this.cachePath = null;
                }
            }
            catch (Exception exception) {
                log.error((Object)("cache.path '" + string + "' could not be used"), (Throwable)exception);
                this.cachePath = null;
            }
        }
    }

    protected void remove(File file) throws CachePersistenceException {
        try {
            while (!file.delete() && file.exists()) {
            }
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable to remove '" + file + "' from the cache: " + exception);
        }
    }

    protected void store(File file, Object object) throws CachePersistenceException {
        File file2 = new File(file.getParent());
        try {
            if (!file2.exists()) {
                file2.mkdirs();
            }
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable to create the directory " + file2);
        }
        while (file.exists() && !file.delete()) {
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable to write '" + file + "' in the cache. Exception: " + exception.getClass().getName() + ", Message: " + exception.getMessage());
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                objectOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected File getCacheFile(String string) {
        char[] cArray = this.getCacheFileName(string);
        File file = new File(this.root, new String(cArray) + "." + CACHE_EXTENSION);
        return file;
    }

    protected abstract char[] getCacheFileName(String var1);

    private File getCacheGroupFile(String string) {
        int n = 30;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid group '" + string + "' specified to getCacheGroupFile.");
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(GROUP_DIRECTORY).append('/');
        stringBuffer.append(string).append('.').append(CACHE_EXTENSION);
        return new File(this.root, stringBuffer.toString());
    }

    private String getPathPart(int n) {
        if (n == 3) {
            return SESSION_CACHE_SUBPATH;
        }
        return APPLICATION_CACHE_SUBPATH;
    }

    private void clear(String string) throws CachePersistenceException {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        try {
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isFile()) {
                        fileArray[i].delete();
                        continue;
                    }
                    this.clear(fileArray[i].toString());
                    fileArray[i].delete();
                }
            }
            file.delete();
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable to clear the cache directory");
        }
    }

    private Object retrieve(File file) throws CachePersistenceException {
        boolean bl;
        Object object = null;
        try {
            bl = file.exists();
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable to verify if " + file + " exists: " + exception);
        }
        if (bl) {
            BufferedInputStream bufferedInputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                objectInputStream = new ObjectInputStream(bufferedInputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                throw new CachePersistenceException("Unable to read '" + file.getAbsolutePath() + "' from the cache: " + exception);
            }
            finally {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

