/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.plugins.clustersupport;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.InitializationException;
import com.opensymphony.oscache.base.LifecycleAware;
import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheGroupEvent;
import com.opensymphony.oscache.base.events.CachePatternEvent;
import com.opensymphony.oscache.base.events.CachewideEvent;
import com.opensymphony.oscache.plugins.clustersupport.ClusterNotification;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBroadcastingListener
implements CacheEntryEventListener,
LifecycleAware {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$plugins$clustersupport$AbstractBroadcastingListener == null ? (class$com$opensymphony$oscache$plugins$clustersupport$AbstractBroadcastingListener = AbstractBroadcastingListener.class$("com.opensymphony.oscache.plugins.clustersupport.AbstractBroadcastingListener")) : class$com$opensymphony$oscache$plugins$clustersupport$AbstractBroadcastingListener));
    protected static final String CLUSTER_ORIGIN = "CLUSTER";
    protected Cache cache = null;
    static /* synthetic */ Class class$com$opensymphony$oscache$plugins$clustersupport$AbstractBroadcastingListener;

    public AbstractBroadcastingListener() {
        if (log.isInfoEnabled()) {
            log.info((Object)"AbstractBroadcastingListener registered");
        }
    }

    public void cacheEntryFlushed(CacheEntryEvent cacheEntryEvent) {
        if (!"NESTED".equals(cacheEntryEvent.getOrigin()) && !CLUSTER_ORIGIN.equals(cacheEntryEvent.getOrigin())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cacheEntryFlushed called (" + cacheEntryEvent + ")"));
            }
            this.sendNotification(new ClusterNotification(1, (Serializable)((Object)cacheEntryEvent.getKey())));
        }
    }

    public void cacheGroupFlushed(CacheGroupEvent cacheGroupEvent) {
        if (!"NESTED".equals(cacheGroupEvent.getOrigin()) && !CLUSTER_ORIGIN.equals(cacheGroupEvent.getOrigin())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cacheGroupFushed called (" + cacheGroupEvent + ")"));
            }
            this.sendNotification(new ClusterNotification(2, (Serializable)((Object)cacheGroupEvent.getGroup())));
        }
    }

    public void cachePatternFlushed(CachePatternEvent cachePatternEvent) {
        if (!"NESTED".equals(cachePatternEvent.getOrigin()) && !CLUSTER_ORIGIN.equals(cachePatternEvent.getOrigin())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cachePatternFushed called (" + cachePatternEvent + ")"));
            }
            this.sendNotification(new ClusterNotification(3, (Serializable)((Object)cachePatternEvent.getPattern())));
        }
    }

    public void cacheFlushed(CachewideEvent cachewideEvent) {
        if (!"NESTED".equals(cachewideEvent.getOrigin()) && !CLUSTER_ORIGIN.equals(cachewideEvent.getOrigin())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cacheFushed called (" + cachewideEvent + ")"));
            }
            this.sendNotification(new ClusterNotification(4, cachewideEvent.getDate()));
        }
    }

    public void cacheEntryAdded(CacheEntryEvent cacheEntryEvent) {
    }

    public void cacheEntryRemoved(CacheEntryEvent cacheEntryEvent) {
    }

    public void cacheEntryUpdated(CacheEntryEvent cacheEntryEvent) {
    }

    public void cacheGroupAdded(CacheGroupEvent cacheGroupEvent) {
    }

    public void cacheGroupEntryAdded(CacheGroupEvent cacheGroupEvent) {
    }

    public void cacheGroupEntryRemoved(CacheGroupEvent cacheGroupEvent) {
    }

    public void cacheGroupRemoved(CacheGroupEvent cacheGroupEvent) {
    }

    public void cacheGroupUpdated(CacheGroupEvent cacheGroupEvent) {
    }

    public void initialize(Cache cache, Config config) throws InitializationException {
        this.cache = cache;
    }

    public void handleClusterNotification(ClusterNotification clusterNotification) {
        if (this.cache == null) {
            log.warn((Object)("A cluster notification (" + clusterNotification + ") was received, but no cache is registered on this machine. Notification ignored."));
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Cluster notification (" + clusterNotification + ") was received."));
        }
        switch (clusterNotification.getType()) {
            case 1: {
                this.cache.flushEntry((String)((Object)clusterNotification.getData()), CLUSTER_ORIGIN);
                break;
            }
            case 2: {
                this.cache.flushGroup((String)((Object)clusterNotification.getData()), CLUSTER_ORIGIN);
                break;
            }
            case 3: {
                this.cache.flushPattern((String)((Object)clusterNotification.getData()), CLUSTER_ORIGIN);
                break;
            }
            case 4: {
                this.cache.flushAll((Date)clusterNotification.getData(), CLUSTER_ORIGIN);
                break;
            }
            default: {
                log.error((Object)("The cluster notification (" + clusterNotification + ") is of an unknown type. Notification ignored."));
            }
        }
    }

    protected abstract void sendNotification(ClusterNotification var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

