/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.extra;

import com.opensymphony.oscache.base.events.ScopeEvent;
import com.opensymphony.oscache.base.events.ScopeEventListener;
import com.opensymphony.oscache.base.events.ScopeEventType;

public class ScopeEventListenerImpl
implements ScopeEventListener {
    public static final String[] SCOPE_NAMES = new String[]{null, "page", "request", "session", "application"};
    public static final int NB_SCOPES = SCOPE_NAMES.length - 1;
    public static final int PAGE_SCOPE = 1;
    public static final int REQUEST_SCOPE = 2;
    public static final int SESSION_SCOPE = 3;
    public static final int APPLICATION_SCOPE = 4;
    private int[] scopeFlushCount = new int[NB_SCOPES + 1];

    public int getApplicationScopeFlushCount() {
        return this.scopeFlushCount[4];
    }

    public int getPageScopeFlushCount() {
        return this.scopeFlushCount[1];
    }

    public int getRequestScopeFlushCount() {
        return this.scopeFlushCount[2];
    }

    public int getSessionScopeFlushCount() {
        return this.scopeFlushCount[3];
    }

    public int getTotalScopeFlushCount() {
        int n = 0;
        for (int i = 1; i <= NB_SCOPES; ++i) {
            n += this.scopeFlushCount[i];
        }
        return n;
    }

    public void scopeFlushed(ScopeEvent scopeEvent) {
        ScopeEventType scopeEventType = scopeEvent.getEventType();
        if (scopeEventType == ScopeEventType.ALL_SCOPES_FLUSHED) {
            int n = 1;
            while (n <= NB_SCOPES) {
                int n2 = n++;
                this.scopeFlushCount[n2] = this.scopeFlushCount[n2] + 1;
            }
        } else if (scopeEventType == ScopeEventType.SCOPE_FLUSHED) {
            int n = scopeEvent.getScope();
            this.scopeFlushCount[n] = this.scopeFlushCount[n] + 1;
        } else {
            throw new IllegalArgumentException("Unknown Scope Event type received");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Flush count for ");
        for (int i = 1; i <= NB_SCOPES; ++i) {
            stringBuffer.append("scope " + SCOPE_NAMES[i] + " = " + this.scopeFlushCount[i] + ", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        return stringBuffer.toString();
    }
}

