/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base.algorithm;

import com.opensymphony.oscache.base.algorithm.AbstractConcurrentReadCache;
import com.opensymphony.oscache.util.ClassLoaderUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUCache
extends AbstractConcurrentReadCache {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$base$algorithm$LRUCache == null ? (class$com$opensymphony$oscache$base$algorithm$LRUCache = LRUCache.class$("com.opensymphony.oscache.base.algorithm.LRUCache")) : class$com$opensymphony$oscache$base$algorithm$LRUCache));
    private Collection list;
    private Map map;
    private boolean isList = false;
    private boolean isMap = false;
    private boolean isSet = false;
    private volatile boolean removeInProgress = false;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$algorithm$LRUCache;

    public LRUCache() {
        try {
            ClassLoaderUtil.loadClass("java.util.LinkedHashSet", this.getClass());
            this.list = new LinkedHashSet();
            this.isSet = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoaderUtil.loadClass("org.apache.commons.collections.SequencedHashMap", this.getClass());
                this.map = new SequencedHashMap();
                this.isMap = true;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                log.warn((Object)"When using the LRUCache under JRE 1.3.x, commons-collections.jar should be added to your classpath to increase OSCache's performance.");
                this.list = new LinkedList();
                this.isList = true;
            }
        }
    }

    public LRUCache(int n) {
        this();
        this.maxEntries = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRetrieved(Object object) {
        while (this.removeInProgress) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.isMap) {
            Map map = this.map;
            synchronized (map) {
                this.map.remove(object);
                this.map.put(object, Boolean.TRUE);
            }
        }
        Collection collection = this.list;
        synchronized (collection) {
            this.list.remove(object);
            this.list.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemPut(Object object) {
        if (this.isMap) {
            Map map = this.map;
            synchronized (map) {
                this.map.remove(object);
                this.map.put(object, Boolean.TRUE);
            }
        }
        Collection collection = this.list;
        synchronized (collection) {
            this.list.remove(object);
            this.list.add(object);
        }
    }

    protected Object removeItem() {
        Object object;
        this.removeInProgress = true;
        try {
            object = this.removeFirst();
        }
        catch (Exception exception) {
            do {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.isMap ? this.list.size() == 0 : this.map.size() == 0);
            object = this.removeFirst();
        }
        this.removeInProgress = false;
        return object;
    }

    protected void itemRemoved(Object object) {
        if (this.isMap) {
            this.map.remove(object);
        } else {
            this.list.remove(object);
        }
    }

    private Object removeFirst() {
        Object object;
        if (this.isSet) {
            Iterator iterator = this.list.iterator();
            object = iterator.next();
            iterator.remove();
        } else if (this.isMap) {
            object = ((SequencedHashMap)this.map).getFirstKey();
            this.map.remove(object);
        } else {
            object = ((List)this.list).remove(0);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

