/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base.algorithm;

import com.opensymphony.oscache.base.CacheEntry;
import com.opensymphony.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConcurrentReadCache
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final String NULL = "_nul!~";
    protected static Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$base$algorithm$AbstractConcurrentReadCache == null ? (class$com$opensymphony$oscache$base$algorithm$AbstractConcurrentReadCache = AbstractConcurrentReadCache.class$("com.opensymphony.oscache.base.algorithm.AbstractConcurrentReadCache")) : class$com$opensymphony$oscache$base$algorithm$AbstractConcurrentReadCache));
    protected final Boolean barrierLock = new Boolean(true);
    protected transient Object lastWrite;
    protected transient Entry[] table;
    protected transient int count;
    protected PersistenceListener persistenceListener = null;
    protected boolean memoryCaching = true;
    protected boolean unlimitedDiskCache = false;
    protected float loadFactor;
    protected final int DEFAULT_MAX_ENTRIES = 100;
    protected final int UNLIMITED = 0x7FFFFFFE;
    protected transient Collection values = null;
    protected HashMap groups = null;
    protected transient Set entrySet = null;
    protected transient Set keySet = null;
    protected int maxEntries = 100;
    protected int threshold;
    private boolean overflowPersistence = false;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$algorithm$AbstractConcurrentReadCache;

    public AbstractConcurrentReadCache(int n, float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        this.loadFactor = f;
        int n2 = this.p2capacity(n);
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f);
    }

    public AbstractConcurrentReadCache(int n) {
        this(n, 0.75f);
    }

    public AbstractConcurrentReadCache() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public AbstractConcurrentReadCache(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public Set getGroup(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroup called (group=" + string + ")"));
        }
        Set set = null;
        if (this.memoryCaching && this.groups != null) {
            set = (Set)this.getGroupsForReading().get(string);
        }
        set = set == null ? this.persistRetrieveGroup(string) : new HashSet(set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEntries(int n) {
        if (n > 0) {
            this.maxEntries = n;
            AbstractConcurrentReadCache abstractConcurrentReadCache = this;
            synchronized (abstractConcurrentReadCache) {
                while (this.size() > this.maxEntries) {
                    this.remove(this.removeItem(), false);
                }
            }
        } else {
            throw new IllegalArgumentException("Cache maximum number of entries must be at least 1");
        }
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMemoryCaching(boolean bl) {
        this.memoryCaching = bl;
    }

    public boolean isMemoryCaching() {
        return this.memoryCaching;
    }

    public void setPersistenceListener(PersistenceListener persistenceListener) {
        this.persistenceListener = persistenceListener;
    }

    public PersistenceListener getPersistenceListener() {
        return this.persistenceListener;
    }

    public void setUnlimitedDiskCache(boolean bl) {
        this.unlimitedDiskCache = bl;
    }

    public boolean isUnlimitedDiskCache() {
        return this.unlimitedDiskCache;
    }

    public boolean isOverflowPersistence() {
        return this.overflowPersistence;
    }

    public void setOverflowPersistence(boolean bl) {
        this.overflowPersistence = bl;
    }

    public synchronized int capacity() {
        return this.table.length;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                entry.value = null;
                this.itemRemoved(entry.key);
                entry = entry.next;
            }
            entryArray[i] = null;
        }
        this.persistClear();
        this.count = 0;
        this.recordModification(entryArray);
    }

    public synchronized Object clone() {
        try {
            AbstractConcurrentReadCache abstractConcurrentReadCache = (AbstractConcurrentReadCache)super.clone();
            abstractConcurrentReadCache.keySet = null;
            abstractConcurrentReadCache.entrySet = null;
            abstractConcurrentReadCache.values = null;
            Entry[] entryArray = this.table;
            Entry[] entryArray2 = abstractConcurrentReadCache.table = new Entry[entryArray.length];
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry = entryArray[i];
                if (entry == null) continue;
                entryArray2[i] = (Entry)entry.clone();
            }
            return abstractConcurrentReadCache;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.getTableForReading();
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Object object2 = entry.value;
                if (object2 != null && object.equals(object2)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    public Set entrySet() {
        Set set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new AbstractSet(){

            public Iterator iterator() {
                return new HashIterator();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object object2 = AbstractConcurrentReadCache.this.get(k);
                return object2 != null && object2.equals(entry.getValue());
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return AbstractConcurrentReadCache.this.findAndRemoveEntry((Map.Entry)object);
            }

            public int size() {
                return AbstractConcurrentReadCache.this.size();
            }

            public void clear() {
                AbstractConcurrentReadCache.this.clear();
            }
        };
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Entry entry;
        if (log.isDebugEnabled()) {
            log.debug((Object)("get called (key=" + object + ")"));
        }
        int n = AbstractConcurrentReadCache.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            Object object2;
            if (entry2 == null) {
                entryArray = this.getTableForReading();
                if (entry == entryArray[n2]) {
                    object2 = this.persistRetrieve(object);
                    if (object2 != null) {
                        this.put(object, object2, false);
                    }
                    return object2;
                }
                n2 = n & entryArray.length - 1;
                entry2 = entry = entryArray[n2];
                continue;
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                object2 = entry2.value;
                if (object2 != null) {
                    if (NULL.equals(object2)) {
                        object2 = this.persistRetrieve(entry2.key);
                        if (object2 != null) {
                            this.itemRetrieved(object);
                        }
                        return object2;
                    }
                    this.itemRetrieved(object);
                    return object2;
                }
                AbstractConcurrentReadCache abstractConcurrentReadCache = this;
                synchronized (abstractConcurrentReadCache) {
                    entryArray = this.table;
                }
                n2 = n & entryArray.length - 1;
                entry2 = entry = entryArray[n2];
                continue;
            }
            entry2 = entry2.next;
        }
    }

    public Set keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new AbstractSet(){

            public Iterator iterator() {
                return new KeyIterator();
            }

            public int size() {
                return AbstractConcurrentReadCache.this.size();
            }

            public boolean contains(Object object) {
                return AbstractConcurrentReadCache.this.containsKey(object);
            }

            public boolean remove(Object object) {
                return AbstractConcurrentReadCache.this.remove(object) != null;
            }

            public void clear() {
                AbstractConcurrentReadCache.this.clear();
            }
        };
        return this.keySet;
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public Object put(Object object, Object object2) {
        return this.put(object, object2, true);
    }

    public synchronized void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.put(k, v);
        }
    }

    public Object remove(Object object) {
        return this.remove(object, true);
    }

    public synchronized int size() {
        return this.count;
    }

    public Collection values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new AbstractCollection(){

            public Iterator iterator() {
                return new ValueIterator();
            }

            public int size() {
                return AbstractConcurrentReadCache.this.size();
            }

            public boolean contains(Object object) {
                return AbstractConcurrentReadCache.this.containsValue(object);
            }

            public void clear() {
                AbstractConcurrentReadCache.this.clear();
            }
        };
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map getGroupsForReading() {
        Boolean bl = this.barrierLock;
        synchronized (bl) {
            return this.groups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry[] getTableForReading() {
        Boolean bl = this.barrierLock;
        synchronized (bl) {
            return this.table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recordModification(Object object) {
        Boolean bl = this.barrierLock;
        synchronized (bl) {
            this.lastWrite = object;
        }
    }

    protected synchronized boolean findAndRemoveEntry(Map.Entry entry) {
        Object k = entry.getKey();
        Object object = this.get(k);
        if (object != null && object.equals(entry.getValue())) {
            this.remove(k);
            return true;
        }
        return false;
    }

    protected void persistRemove(Object object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PersistRemove called (key=" + object + ")"));
        }
        if (this.persistenceListener != null) {
            try {
                this.persistenceListener.remove((String)object);
            }
            catch (CachePersistenceException cachePersistenceException) {
                log.error((Object)("[oscache] Exception removing cache entry with key '" + object + "' from persistence"), (Throwable)cachePersistenceException);
            }
        }
    }

    protected void persistRemoveGroup(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("persistRemoveGroup called (groupName=" + string + ")"));
        }
        if (this.persistenceListener != null) {
            try {
                this.persistenceListener.removeGroup(string);
            }
            catch (CachePersistenceException cachePersistenceException) {
                log.error((Object)("[oscache] Exception removing group " + string), (Throwable)cachePersistenceException);
            }
        }
    }

    protected Object persistRetrieve(Object object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("persistRetrieve called (key=" + object + ")"));
        }
        Object object2 = null;
        if (this.persistenceListener != null) {
            try {
                object2 = this.persistenceListener.retrieve((String)object);
            }
            catch (CachePersistenceException cachePersistenceException) {
                // empty catch block
            }
        }
        return object2;
    }

    protected Set persistRetrieveGroup(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("persistRetrieveGroup called (groupName=" + string + ")"));
        }
        if (this.persistenceListener != null) {
            try {
                return this.persistenceListener.retrieveGroup(string);
            }
            catch (CachePersistenceException cachePersistenceException) {
                log.error((Object)("[oscache] Exception retrieving group " + string), (Throwable)cachePersistenceException);
            }
        }
        return null;
    }

    protected void persistStore(Object object, Object object2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("persistStore called (key=" + object + ")"));
        }
        if (this.persistenceListener != null) {
            try {
                this.persistenceListener.store((String)object, object2);
            }
            catch (CachePersistenceException cachePersistenceException) {
                log.error((Object)("[oscache] Exception persisting " + object), (Throwable)cachePersistenceException);
            }
        }
    }

    protected void persistStoreGroup(String string, Set set) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("persistStoreGroup called (groupName=" + string + ")"));
        }
        if (this.persistenceListener != null) {
            try {
                if (set == null || set.isEmpty()) {
                    this.persistenceListener.removeGroup(string);
                } else {
                    this.persistenceListener.storeGroup(string, set);
                }
            }
            catch (CachePersistenceException cachePersistenceException) {
                log.error((Object)("[oscache] Exception persisting group " + string), (Throwable)cachePersistenceException);
            }
        }
    }

    protected void persistClear() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"persistClear called");
        }
        if (this.persistenceListener != null) {
            try {
                this.persistenceListener.clear();
            }
            catch (CachePersistenceException cachePersistenceException) {
                log.error((Object)"[oscache] Exception clearing persistent cache", (Throwable)cachePersistenceException);
            }
        }
    }

    protected abstract void itemPut(Object var1);

    protected abstract void itemRetrieved(Object var1);

    protected abstract void itemRemoved(Object var1);

    protected abstract Object removeItem();

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        if (n >= 0x40000000) {
            return;
        }
        int n2 = n << 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        for (int i = 0; i < n; ++i) {
            Entry entry = null;
            Entry entry2 = null;
            Entry entry3 = entryArray[i];
            while (entry3 != null) {
                int n3 = entry3.hash;
                Entry entry4 = entry3.next;
                if ((n3 & n) == 0) {
                    if (entry == null && (entry4 == null || entry4.next == null && (entry4.hash & n) == 0)) {
                        entry = entry3;
                        break;
                    }
                    entry = new Entry(n3, entry3.key, entry3.value, entry);
                } else {
                    if (entry2 == null && (entry4 == null || entry4.next == null && (entry4.hash & n) != 0)) {
                        entry2 = entry3;
                        break;
                    }
                    entry2 = new Entry(n3, entry3.key, entry3.value, entry2);
                }
                entry3 = entry4;
            }
            entryArray2[i] = entry;
            entryArray2[n + i] = entry2;
        }
        this.table = entryArray2;
        this.recordModification(entryArray2);
    }

    protected Object sput(Object object, Object object2, int n, boolean bl) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                Entry entry3 = this.memoryCaching ? new Entry(n, object, object2, entry) : new Entry(n, object, NULL, entry);
                this.itemPut(object);
                if (bl && !this.overflowPersistence) {
                    this.persistStore(object, object2);
                }
                if (object2 instanceof CacheEntry) {
                    this.updateGroups(null, (CacheEntry)object2, bl);
                }
                entryArray[n2] = entry3;
                if (++this.count >= this.threshold) {
                    this.rehash();
                } else {
                    this.recordModification(entry3);
                }
                return null;
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                Object object3 = entry2.value;
                if (this.memoryCaching) {
                    entry2.value = object2;
                }
                if (bl && this.overflowPersistence) {
                    this.persistRemove(object);
                } else if (bl) {
                    this.persistStore(object, object2);
                }
                this.updateGroups(object3, object2, bl);
                this.itemPut(object);
                return object3;
            }
            entry2 = entry2.next;
        }
    }

    protected Object sremove(Object object, int n, boolean bl) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                Object object2 = entry2.value;
                entry2.value = null;
                --this.count;
                if (!this.unlimitedDiskCache && !this.overflowPersistence) {
                    this.persistRemove(entry2.key);
                }
                if (this.overflowPersistence && this.size() + 1 >= this.maxEntries) {
                    this.persistStore(object, object2);
                }
                if (bl) {
                    this.itemRemoved(object);
                }
                Entry entry3 = entry2.next;
                Entry entry4 = entry;
                while (entry4 != entry2) {
                    entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                    entry4 = entry4.next;
                }
                entryArray[n2] = entry3;
                this.recordModification(entry3);
                return object2;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            Entry entry = this.table[i];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private static int hash(Object object) {
        int n = object.hashCode();
        return (n << 7) - n + (n >>> 9) + (n >>> 17);
    }

    private void addGroupMappings(String string, Set set, boolean bl) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            HashSet<String> hashSet;
            String string2 = (String)iterator.next();
            if (this.memoryCaching) {
                if (this.groups == null) {
                    this.groups = new HashMap();
                }
                if ((hashSet = (Set)this.groups.get(string2)) == null) {
                    hashSet = new HashSet();
                    this.groups.put(string2, hashSet);
                }
                hashSet.add(string);
            }
            if (!bl) continue;
            hashSet = this.persistRetrieveGroup(string2);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string);
            this.persistStoreGroup(string2, hashSet);
        }
    }

    private int p2capacity(int n) {
        int n2;
        int n3 = n;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            for (n2 = 4; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object put(Object object, Object object2, boolean bl) {
        Entry entry;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = AbstractConcurrentReadCache.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                AbstractConcurrentReadCache abstractConcurrentReadCache = this;
                synchronized (abstractConcurrentReadCache) {
                    entryArray = this.table;
                    if (this.size() >= this.maxEntries) {
                        this.remove(this.removeItem(), false);
                    }
                    if (entry == entryArray[n2]) {
                        Entry entry3 = null;
                        entry3 = this.memoryCaching ? new Entry(n, object, object2, entry) : new Entry(n, object, NULL, entry);
                        entryArray[n2] = entry3;
                        this.itemPut(object);
                        if (bl && !this.overflowPersistence) {
                            this.persistStore(object, object2);
                        }
                        if (object2 instanceof CacheEntry) {
                            this.updateGroups(null, (CacheEntry)object2, bl);
                        }
                        if (++this.count >= this.threshold) {
                            this.rehash();
                        } else {
                            this.recordModification(entry3);
                        }
                        return entry3;
                    }
                    return this.sput(object, object2, n, bl);
                }
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                AbstractConcurrentReadCache abstractConcurrentReadCache = this;
                synchronized (abstractConcurrentReadCache) {
                    entryArray = this.table;
                    Object object3 = entry2.value;
                    if (bl && object3 == NULL) {
                        object3 = this.persistRetrieve(object);
                    }
                    if (entry == entryArray[n2] && object3 != null) {
                        if (this.memoryCaching) {
                            entry2.value = object2;
                        }
                        if (bl && this.overflowPersistence) {
                            this.persistRemove(object);
                        } else if (bl) {
                            this.persistStore(object, object2);
                        }
                        this.updateGroups(object3, object2, bl);
                        this.itemPut(object);
                        return object3;
                    }
                    return this.sput(object, object2, n, bl);
                }
            }
            entry2 = entry2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object remove(Object object, boolean bl) {
        Entry entry;
        if (object == null) {
            return null;
        }
        int n = AbstractConcurrentReadCache.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                entryArray = this.getTableForReading();
                if (entry == entryArray[n2]) {
                    return null;
                }
                return this.sremove(object, n, bl);
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                AbstractConcurrentReadCache abstractConcurrentReadCache = this;
                synchronized (abstractConcurrentReadCache) {
                    entryArray = this.table;
                    Object object2 = entry2.value;
                    if (entry != entryArray[n2] || object2 == null) {
                        return this.sremove(object, n, bl);
                    }
                    entry2.value = null;
                    --this.count;
                    if (!this.unlimitedDiskCache && !this.overflowPersistence) {
                        this.persistRemove(entry2.key);
                    }
                    if (this.overflowPersistence && this.size() + 1 >= this.maxEntries) {
                        this.persistStore(object, object2);
                    }
                    if (bl) {
                        this.itemRemoved(object);
                    }
                    Entry entry3 = entry2.next;
                    Entry entry4 = entry;
                    while (entry4 != entry2) {
                        entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                        entry4 = entry4.next;
                    }
                    entryArray[n2] = entry3;
                    this.recordModification(entry3);
                    return object2;
                }
            }
            entry2 = entry2.next;
        }
    }

    private void removeGroupMappings(String string, Set set, boolean bl) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set set2;
            String string2 = (String)iterator.next();
            if (this.memoryCaching && this.groups != null && (set2 = (Set)this.groups.get(string2)) != null) {
                set2.remove(string);
                if (set2.isEmpty()) {
                    this.groups.remove(string2);
                }
            }
            if (!bl || (set2 = this.persistRetrieveGroup(string2)) == null) continue;
            set2.remove(string);
            if (set2.isEmpty()) {
                this.persistRemoveGroup(string2);
                continue;
            }
            this.persistStoreGroup(string2, set2);
        }
    }

    private void updateGroups(Object object, Object object2, boolean bl) {
        boolean bl2 = object instanceof CacheEntry;
        boolean bl3 = object2 instanceof CacheEntry;
        if (bl3 && bl2) {
            this.updateGroups((CacheEntry)object, (CacheEntry)object2, bl);
        } else if (bl3) {
            this.updateGroups(null, (CacheEntry)object2, bl);
        } else if (bl2) {
            this.updateGroups((CacheEntry)object, null, bl);
        }
    }

    private void updateGroups(CacheEntry cacheEntry, CacheEntry cacheEntry2, boolean bl) {
        String string;
        Iterator iterator;
        HashSet<String> hashSet;
        Set set = null;
        Set set2 = null;
        if (cacheEntry != null) {
            set = cacheEntry.getGroups();
        }
        if (cacheEntry2 != null) {
            set2 = cacheEntry2.getGroups();
        }
        if (set != null) {
            hashSet = new HashSet<String>();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (set2 != null && set2.contains(string)) continue;
                hashSet.add(string);
            }
            this.removeGroupMappings(cacheEntry.getKey(), hashSet, bl);
        }
        if (set2 != null) {
            hashSet = new HashSet();
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (set != null && set.contains(string)) continue;
                hashSet.add(string);
            }
            this.addGroupMappings(cacheEntry2.getKey(), hashSet, bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final Entry next;
        protected final Object key;
        protected final int hash;
        protected volatile Object value;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.next = entry;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (!this.key.equals(entry.getKey())) {
                return false;
            }
            Object object2 = this.value;
            return object2 == null ? entry.getValue() == null : object2.equals(entry.getValue());
        }

        public int hashCode() {
            Object object = this.value;
            return this.hash ^ (object == null ? 0 : object.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected Entry entry = null;
        protected Entry lastReturned = null;
        protected Object currentKey;
        protected Object currentValue;
        protected int index;

        protected HashIterator() {
            this.tab = AbstractConcurrentReadCache.this.getTableForReading();
            this.index = this.tab.length - 1;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object object = this.entry.value;
                    if (object != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = object;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return object;
        }

        public Object nextElement() {
            return this.next();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            AbstractConcurrentReadCache.this.remove(this.lastReturned.key);
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }
}

