/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config
implements Serializable {
    private static final transient Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$base$Config == null ? (class$com$opensymphony$oscache$base$Config = Config.class$("com.opensymphony.oscache.base.Config")) : class$com$opensymphony$oscache$base$Config));
    private static final String PROPERTIES_FILENAME = "/oscache.properties";
    private Properties properties = null;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$Config;

    public Config() {
        this(null);
    }

    public Config(Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Config() called");
        }
        if (properties == null) {
            this.loadProps();
        } else {
            this.properties = properties;
        }
    }

    public String getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (this.properties == null) {
            return null;
        }
        String string2 = this.properties.getProperty(string);
        return string2;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object get(Object object) {
        return this.properties.get(object);
    }

    public void set(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (object2 == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting Config");
        }
        this.properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(PROPERTIES_FILENAME);
            this.properties.load(inputStream);
            log.info((Object)("Properties " + this.properties));
        }
        catch (Exception exception) {
            log.error((Object)("Error reading /oscache.properties in CacheAdministrator.loadProps() " + exception));
            log.error((Object)"Ensure the /oscache.properties file is readable and in your classpath.");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

