/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base;

import com.opensymphony.oscache.base.EntryRefreshPolicy;
import com.opensymphony.oscache.web.filter.ResponseContent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CacheEntry
implements Serializable {
    private static final byte NOT_YET = -1;
    public static final int INDEFINITE_EXPIRY = -1;
    private EntryRefreshPolicy policy = null;
    private Object content = null;
    private Set groups = null;
    private String key;
    private boolean wasFlushed = false;
    private long created = -1L;
    private long lastUpdate = -1L;
    static /* synthetic */ Class class$java$lang$String;

    public CacheEntry(String string) {
        this(string, null);
    }

    public CacheEntry(String string, EntryRefreshPolicy entryRefreshPolicy) {
        this(string, entryRefreshPolicy, null);
    }

    public CacheEntry(String string, EntryRefreshPolicy entryRefreshPolicy, String[] stringArray) {
        this.key = string;
        if (stringArray != null) {
            this.groups = new HashSet(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.groups.add(stringArray[i]);
            }
        }
        this.policy = entryRefreshPolicy;
        this.created = System.currentTimeMillis();
    }

    public synchronized void setContent(Object object) {
        this.content = object;
        this.lastUpdate = System.currentTimeMillis();
        this.wasFlushed = false;
    }

    public Object getContent() {
        return this.content;
    }

    public long getCreated() {
        return this.created;
    }

    public synchronized void setGroups(String[] stringArray) {
        if (stringArray != null) {
            this.groups = new HashSet(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.groups.add(stringArray[i]);
            }
        } else {
            this.groups = null;
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void setGroups(Collection collection) {
        this.groups = collection != null ? new HashSet(collection) : null;
        this.lastUpdate = System.currentTimeMillis();
    }

    public Set getGroups() {
        return this.groups;
    }

    public String getKey() {
        return this.key;
    }

    public void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isNew() {
        return this.lastUpdate == -1L;
    }

    public int getSize() {
        int n = this.key.length() * 2 + 4;
        if (this.content.getClass() == (class$java$lang$String == null ? (class$java$lang$String = CacheEntry.class$("java.lang.String")) : class$java$lang$String)) {
            n += this.content.toString().length() * 2 + 4;
        } else if (this.content instanceof ResponseContent) {
            n += ((ResponseContent)this.content).getSize();
        } else {
            return -1;
        }
        return n + 17;
    }

    public void flush() {
        this.wasFlushed = true;
    }

    public boolean needsRefresh(int n) {
        boolean bl = this.lastUpdate == -1L ? true : (this.wasFlushed ? true : (n == 0 ? true : (this.policy != null ? this.policy.needsRefresh(this) : n >= 0 && System.currentTimeMillis() >= this.lastUpdate + (long)n * 1000L)));
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

