/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base;

import com.opensymphony.oscache.base.CacheEntry;
import com.opensymphony.oscache.base.EntryRefreshPolicy;
import com.opensymphony.oscache.base.EntryUpdateState;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.base.algorithm.AbstractConcurrentReadCache;
import com.opensymphony.oscache.base.algorithm.LRUCache;
import com.opensymphony.oscache.base.algorithm.UnlimitedCache;
import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheEntryEventType;
import com.opensymphony.oscache.base.events.CacheEventListener;
import com.opensymphony.oscache.base.events.CacheGroupEvent;
import com.opensymphony.oscache.base.events.CacheMapAccessEvent;
import com.opensymphony.oscache.base.events.CacheMapAccessEventListener;
import com.opensymphony.oscache.base.events.CacheMapAccessEventType;
import com.opensymphony.oscache.base.events.CachePatternEvent;
import com.opensymphony.oscache.base.events.CachewideEvent;
import com.opensymphony.oscache.base.events.CachewideEventType;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import com.opensymphony.oscache.util.FastCronParser;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cache
implements Serializable {
    public static final String NESTED_EVENT = "NESTED";
    private static final transient Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$base$Cache == null ? (class$com$opensymphony$oscache$base$Cache = Cache.class$("com.opensymphony.oscache.base.Cache")) : class$com$opensymphony$oscache$base$Cache));
    protected EventListenerList listenerList = new EventListenerList();
    private AbstractConcurrentReadCache cacheMap = null;
    private Date flushDateTime = null;
    private Map updateStates = new HashMap();
    private boolean blocking = false;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$Cache;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$events$CacheEventListener;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$events$CacheEntryEventListener;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$events$CacheMapAccessEventListener;

    public Cache(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, bl3, false, null, 0);
    }

    public Cache(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, int n) {
        if (string != null && string.length() > 0 && n > 0) {
            try {
                this.cacheMap = (AbstractConcurrentReadCache)Class.forName(string).newInstance();
                this.cacheMap.setMaxEntries(n);
            }
            catch (Exception exception) {
                log.error((Object)("Invalid class name for cache algorithm class. " + exception.toString()));
            }
        }
        if (this.cacheMap == null) {
            this.cacheMap = n > 0 ? new LRUCache(n) : new UnlimitedCache();
        }
        this.cacheMap.setUnlimitedDiskCache(bl2);
        this.cacheMap.setOverflowPersistence(bl3);
        this.cacheMap.setMemoryCaching(bl);
        this.blocking = bl4;
    }

    public void setCapacity(int n) {
        this.cacheMap.setMaxEntries(n);
    }

    public boolean isFlushed(CacheEntry cacheEntry) {
        if (this.flushDateTime != null) {
            long l = cacheEntry.getLastUpdate();
            return this.flushDateTime.getTime() >= l;
        }
        return false;
    }

    public Object getFromCache(String string) throws NeedsRefreshException {
        return this.getFromCache(string, -1, null);
    }

    public Object getFromCache(String string, int n) throws NeedsRefreshException {
        return this.getFromCache(string, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromCache(String string, int n, String string2) throws NeedsRefreshException {
        CacheEntry cacheEntry = this.getCacheEntry(string, null, null);
        Object object = cacheEntry.getContent();
        CacheMapAccessEventType cacheMapAccessEventType = CacheMapAccessEventType.HIT;
        boolean bl = false;
        if (this.isStale(cacheEntry, n, string2)) {
            EntryUpdateState entryUpdateState;
            EntryUpdateState entryUpdateState2 = entryUpdateState = this.getUpdateState(string);
            synchronized (entryUpdateState2) {
                if (entryUpdateState.isAwaitingUpdate() || entryUpdateState.isCancelled()) {
                    entryUpdateState.startUpdate();
                    cacheMapAccessEventType = cacheEntry.isNew() ? CacheMapAccessEventType.MISS : CacheMapAccessEventType.STALE_HIT;
                } else if (entryUpdateState.isUpdating()) {
                    if (cacheEntry.isNew() || this.blocking) {
                        do {
                            try {
                                entryUpdateState.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (entryUpdateState.isUpdating());
                        if (entryUpdateState.isCancelled()) {
                            entryUpdateState.startUpdate();
                            Map map = this.updateStates;
                            synchronized (map) {
                                this.updateStates.put(string, entryUpdateState);
                            }
                            cacheMapAccessEventType = cacheEntry.isNew() ? CacheMapAccessEventType.MISS : CacheMapAccessEventType.STALE_HIT;
                        } else if (entryUpdateState.isComplete()) {
                            bl = true;
                        } else {
                            log.error((Object)("Invalid update state for cache entry " + string));
                        }
                    }
                } else {
                    bl = true;
                }
            }
        }
        if (bl) {
            cacheEntry = (CacheEntry)this.cacheMap.get(string);
            if (cacheEntry != null) {
                object = cacheEntry.getContent();
            } else {
                log.error((Object)"Could not reload cache entry after waiting for it to be rebuilt");
            }
        }
        this.dispatchCacheMapAccessEvent(cacheMapAccessEventType, cacheEntry, null);
        if (cacheMapAccessEventType != CacheMapAccessEventType.HIT) {
            throw new NeedsRefreshException(object);
        }
        return object;
    }

    public void setPersistenceListener(PersistenceListener persistenceListener) {
        this.cacheMap.setPersistenceListener(persistenceListener);
    }

    public PersistenceListener getPersistenceListener() {
        return this.cacheMap.getPersistenceListener();
    }

    public void addCacheEventListener(CacheEventListener cacheEventListener, Class clazz) {
        if ((class$com$opensymphony$oscache$base$events$CacheEventListener == null ? (class$com$opensymphony$oscache$base$events$CacheEventListener = Cache.class$("com.opensymphony.oscache.base.events.CacheEventListener")) : class$com$opensymphony$oscache$base$events$CacheEventListener).isAssignableFrom(clazz)) {
            this.listenerList.add(clazz, cacheEventListener);
        } else {
            log.error((Object)("The class '" + clazz.getName() + "' is not a CacheEventListener. Ignoring this listener."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelUpdate(String string) {
        if (string != null) {
            Map map = this.updateStates;
            synchronized (map) {
                EntryUpdateState entryUpdateState = (EntryUpdateState)this.updateStates.remove(string);
                if (entryUpdateState != null) {
                    EntryUpdateState entryUpdateState2 = entryUpdateState;
                    synchronized (entryUpdateState2) {
                        entryUpdateState.cancelUpdate();
                        entryUpdateState.notify();
                    }
                }
            }
        }
    }

    public void flushAll(Date date) {
        this.flushAll(date, null);
    }

    public void flushAll(Date date, String string) {
        this.flushDateTime = date;
        if (this.listenerList.getListenerCount() > 0) {
            this.dispatchCachewideEvent(CachewideEventType.CACHE_FLUSHED, date, string);
        }
    }

    public void flushEntry(String string) {
        this.flushEntry(string, null);
    }

    public void flushEntry(String string, String string2) {
        this.flushEntry(this.getCacheEntry(string, null, string2), string2);
    }

    public void flushGroup(String string) {
        this.flushGroup(string, null);
    }

    public void flushGroup(String string, String string2) {
        Set set = this.cacheMap.getGroup(string);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                CacheEntry cacheEntry = (CacheEntry)this.cacheMap.get(string3);
                if (cacheEntry == null || cacheEntry.needsRefresh(-1)) continue;
                this.flushEntry(cacheEntry, NESTED_EVENT);
            }
        }
        if (this.listenerList.getListenerCount() > 0) {
            this.dispatchCacheGroupEvent(CacheEntryEventType.GROUP_FLUSHED, string, string2);
        }
    }

    public void flushPattern(String string) {
        this.flushPattern(string, null);
    }

    public void flushPattern(String string, String string2) {
        if (string != null && string.length() > 0) {
            String string3 = null;
            CacheEntry cacheEntry = null;
            Iterator iterator = this.cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (string3.indexOf(string) < 0 || (cacheEntry = (CacheEntry)this.cacheMap.get(string3)) == null) continue;
                this.flushEntry(cacheEntry, string2);
            }
            if (this.listenerList.getListenerCount() > 0) {
                this.dispatchCachePatternEvent(CacheEntryEventType.PATTERN_FLUSHED, string, string2);
            }
        }
    }

    public void putInCache(String string, Object object) {
        this.putInCache(string, object, null, null, null);
    }

    public void putInCache(String string, Object object, EntryRefreshPolicy entryRefreshPolicy) {
        this.putInCache(string, object, null, entryRefreshPolicy, null);
    }

    public void putInCache(String string, Object object, String[] stringArray) {
        this.putInCache(string, object, stringArray, null, null);
    }

    public void putInCache(String string, Object object, String[] stringArray, EntryRefreshPolicy entryRefreshPolicy, String string2) {
        CacheEntry cacheEntry = this.getCacheEntry(string, entryRefreshPolicy, string2);
        boolean bl = cacheEntry.isNew();
        if (!bl) {
            cacheEntry = new CacheEntry(string, entryRefreshPolicy);
        }
        cacheEntry.setContent(object);
        cacheEntry.setGroups(stringArray);
        this.cacheMap.put(string, cacheEntry);
        this.completeUpdate(string);
        if (this.listenerList.getListenerCount() > 0) {
            CacheEntryEvent cacheEntryEvent = new CacheEntryEvent(this, cacheEntry, string2);
            if (bl) {
                this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_ADDED, cacheEntryEvent);
            } else {
                this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_UPDATED, cacheEntryEvent);
            }
        }
    }

    public void removeCacheEventListener(CacheEventListener cacheEventListener, Class clazz) {
        this.listenerList.remove(clazz, cacheEventListener);
    }

    protected CacheEntry getCacheEntry(String string, EntryRefreshPolicy entryRefreshPolicy, String string2) {
        CacheEntry cacheEntry = null;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("getCacheEntry called with an empty or null key");
        }
        cacheEntry = (CacheEntry)this.cacheMap.get(string);
        if (cacheEntry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No cache entry exists for key='" + string + "', creating"));
            }
            cacheEntry = new CacheEntry(string, entryRefreshPolicy);
        }
        return cacheEntry;
    }

    protected boolean isStale(CacheEntry cacheEntry, int n, String string) {
        boolean bl;
        boolean bl2 = bl = cacheEntry.needsRefresh(n) || this.isFlushed(cacheEntry);
        if (string != null && string.length() > 0) {
            try {
                FastCronParser fastCronParser = new FastCronParser(string);
                bl = bl || fastCronParser.hasMoreRecentMatch(cacheEntry.getLastUpdate());
            }
            catch (ParseException parseException) {
                log.warn((Object)parseException);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntryUpdateState getUpdateState(String string) {
        EntryUpdateState entryUpdateState;
        Map map = this.updateStates;
        synchronized (map) {
            entryUpdateState = (EntryUpdateState)this.updateStates.get(string);
            if (entryUpdateState == null) {
                entryUpdateState = new EntryUpdateState();
                this.updateStates.put(string, entryUpdateState);
            }
        }
        return entryUpdateState;
    }

    protected void clear() {
        this.cacheMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeUpdate(String string) {
        Map map = this.updateStates;
        synchronized (map) {
            EntryUpdateState entryUpdateState = (EntryUpdateState)this.updateStates.remove(string);
            if (entryUpdateState != null) {
                EntryUpdateState entryUpdateState2 = entryUpdateState;
                synchronized (entryUpdateState2) {
                    entryUpdateState.completeUpdate();
                    entryUpdateState.notifyAll();
                }
            }
        }
    }

    protected void removeEntry(String string) {
        this.removeEntry(string, null);
    }

    protected void removeEntry(String string, String string2) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheMap.get(string);
        this.cacheMap.remove(string);
        if (this.listenerList.getListenerCount() > 0) {
            CacheEntryEvent cacheEntryEvent = new CacheEntryEvent(this, cacheEntry, string2);
            this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_REMOVED, cacheEntryEvent);
        }
    }

    private void dispatchCacheEntryEvent(CacheEntryEventType cacheEntryEventType, CacheEntryEvent cacheEntryEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$opensymphony$oscache$base$events$CacheEntryEventListener == null ? Cache.class$("com.opensymphony.oscache.base.events.CacheEntryEventListener") : class$com$opensymphony$oscache$base$events$CacheEntryEventListener)) continue;
            if (cacheEntryEventType.equals(CacheEntryEventType.ENTRY_ADDED)) {
                ((CacheEntryEventListener)objectArray[i + 1]).cacheEntryAdded(cacheEntryEvent);
                continue;
            }
            if (cacheEntryEventType.equals(CacheEntryEventType.ENTRY_UPDATED)) {
                ((CacheEntryEventListener)objectArray[i + 1]).cacheEntryUpdated(cacheEntryEvent);
                continue;
            }
            if (cacheEntryEventType.equals(CacheEntryEventType.ENTRY_FLUSHED)) {
                ((CacheEntryEventListener)objectArray[i + 1]).cacheEntryFlushed(cacheEntryEvent);
                continue;
            }
            if (!cacheEntryEventType.equals(CacheEntryEventType.ENTRY_REMOVED)) continue;
            ((CacheEntryEventListener)objectArray[i + 1]).cacheEntryRemoved(cacheEntryEvent);
        }
    }

    private void dispatchCacheGroupEvent(CacheEntryEventType cacheEntryEventType, String string, String string2) {
        CacheGroupEvent cacheGroupEvent = new CacheGroupEvent(this, string, string2);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$opensymphony$oscache$base$events$CacheEntryEventListener == null ? Cache.class$("com.opensymphony.oscache.base.events.CacheEntryEventListener") : class$com$opensymphony$oscache$base$events$CacheEntryEventListener) || !cacheEntryEventType.equals(CacheEntryEventType.GROUP_FLUSHED)) continue;
            ((CacheEntryEventListener)objectArray[i + 1]).cacheGroupFlushed(cacheGroupEvent);
        }
    }

    private void dispatchCacheMapAccessEvent(CacheMapAccessEventType cacheMapAccessEventType, CacheEntry cacheEntry, String string) {
        CacheMapAccessEvent cacheMapAccessEvent = new CacheMapAccessEvent(cacheMapAccessEventType, cacheEntry, string);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$opensymphony$oscache$base$events$CacheMapAccessEventListener == null ? Cache.class$("com.opensymphony.oscache.base.events.CacheMapAccessEventListener") : class$com$opensymphony$oscache$base$events$CacheMapAccessEventListener)) continue;
            ((CacheMapAccessEventListener)objectArray[i + 1]).accessed(cacheMapAccessEvent);
        }
    }

    private void dispatchCachePatternEvent(CacheEntryEventType cacheEntryEventType, String string, String string2) {
        CachePatternEvent cachePatternEvent = new CachePatternEvent(this, string, string2);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$opensymphony$oscache$base$events$CacheEntryEventListener == null ? Cache.class$("com.opensymphony.oscache.base.events.CacheEntryEventListener") : class$com$opensymphony$oscache$base$events$CacheEntryEventListener) || !cacheEntryEventType.equals(CacheEntryEventType.PATTERN_FLUSHED)) continue;
            ((CacheEntryEventListener)objectArray[i + 1]).cachePatternFlushed(cachePatternEvent);
        }
    }

    private void dispatchCachewideEvent(CachewideEventType cachewideEventType, Date date, String string) {
        CachewideEvent cachewideEvent = new CachewideEvent(this, date, string);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$opensymphony$oscache$base$events$CacheEntryEventListener == null ? Cache.class$("com.opensymphony.oscache.base.events.CacheEntryEventListener") : class$com$opensymphony$oscache$base$events$CacheEntryEventListener) || !cachewideEventType.equals(CachewideEventType.CACHE_FLUSHED)) continue;
            ((CacheEntryEventListener)objectArray[i + 1]).cacheFlushed(cachewideEvent);
        }
    }

    private void flushEntry(CacheEntry cacheEntry, String string) {
        String string2 = cacheEntry.getKey();
        cacheEntry.flush();
        if (!cacheEntry.isNew()) {
            this.cacheMap.put(string2, cacheEntry);
        }
        if (this.listenerList.getListenerCount() > 0) {
            CacheEntryEvent cacheEntryEvent = new CacheEntryEvent(this, cacheEntry, string);
            this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_FLUSHED, cacheEntryEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

