/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.FinalizationException;
import com.opensymphony.oscache.base.InitializationException;
import com.opensymphony.oscache.base.LifecycleAware;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheEventListener;
import com.opensymphony.oscache.base.events.CacheMapAccessEventListener;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import com.opensymphony.oscache.util.StringUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCacheAdministrator
implements Serializable {
    private static final transient Log log = LogFactory.getLog((Class)(class$com$opensymphony$oscache$base$AbstractCacheAdministrator == null ? (class$com$opensymphony$oscache$base$AbstractCacheAdministrator = AbstractCacheAdministrator.class$("com.opensymphony.oscache.base.AbstractCacheAdministrator")) : class$com$opensymphony$oscache$base$AbstractCacheAdministrator));
    public static final String CACHE_MEMORY_KEY = "cache.memory";
    public static final String CACHE_CAPACITY_KEY = "cache.capacity";
    public static final String CACHE_ALGORITHM_KEY = "cache.algorithm";
    public static final String CACHE_DISK_UNLIMITED_KEY = "cache.unlimited.disk";
    public static final String CACHE_BLOCKING_KEY = "cache.blocking";
    public static final String PERSISTENCE_CLASS_KEY = "cache.persistence.class";
    private static final String CACHE_PERSISTENCE_OVERFLOW_KEY = "cache.persistence.overflow.only";
    public static final String CACHE_ENTRY_EVENT_LISTENERS_KEY = "cache.event.listeners";
    protected Config config = null;
    protected EventListenerList listenerList = new EventListenerList();
    protected String algorithmClass = null;
    protected int cacheCapacity = -1;
    private boolean blocking = false;
    private boolean memoryCaching = true;
    private boolean overflowPersistence;
    private boolean unlimitedDiskCache;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$AbstractCacheAdministrator;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$events$CacheEventListener;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$events$CacheEntryEventListener;
    static /* synthetic */ Class class$com$opensymphony$oscache$base$events$CacheMapAccessEventListener;

    protected AbstractCacheAdministrator() {
        this(null);
    }

    protected AbstractCacheAdministrator(Properties properties) {
        this.loadProps(properties);
        this.initCacheParameters();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Constructed AbstractCacheAdministrator()");
        }
    }

    public void setAlgorithmClass(String string) {
        this.algorithmClass = string;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    protected void setCacheCapacity(int n) {
        this.cacheCapacity = n;
    }

    public boolean isMemoryCaching() {
        return this.memoryCaching;
    }

    public String getProperty(String string) {
        return this.config.getProperty(string);
    }

    public boolean isUnlimitedDiskCache() {
        return this.unlimitedDiskCache;
    }

    public boolean isOverflowPersistence() {
        return this.overflowPersistence;
    }

    public void setOverflowPersistence(boolean bl) {
        this.overflowPersistence = bl;
    }

    protected CacheEventListener[] getCacheEventListeners() {
        CacheEventListener[] cacheEventListenerArray = null;
        List list = StringUtil.split(this.config.getProperty(CACHE_ENTRY_EVENT_LISTENERS_KEY), ',');
        cacheEventListenerArray = new CacheEventListener[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            try {
                Class<?> clazz = Class.forName(string);
                if (!(class$com$opensymphony$oscache$base$events$CacheEventListener == null ? AbstractCacheAdministrator.class$("com.opensymphony.oscache.base.events.CacheEventListener") : class$com$opensymphony$oscache$base$events$CacheEventListener).isAssignableFrom(clazz)) {
                    log.error((Object)("Specified listener class '" + string + "' does not implement CacheEventListener. Ignoring this listener."));
                    continue;
                }
                cacheEventListenerArray[i] = (CacheEventListener)clazz.newInstance();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error((Object)("CacheEventListener class '" + string + "' not found. Ignoring this listener."), (Throwable)classNotFoundException);
                continue;
            }
            catch (InstantiationException instantiationException) {
                log.error((Object)("CacheEventListener class '" + string + "' could not be instantiated because it is not a concrete class. Ignoring this listener."), (Throwable)instantiationException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error((Object)("CacheEventListener class '" + string + "' could not be instantiated because it is not public. Ignoring this listener."), (Throwable)illegalAccessException);
            }
        }
        return cacheEventListenerArray;
    }

    protected Cache setPersistenceListener(Cache cache) {
        String string = this.config.getProperty(PERSISTENCE_CLASS_KEY);
        try {
            Class<?> clazz = Class.forName(string);
            PersistenceListener persistenceListener = (PersistenceListener)clazz.newInstance();
            cache.setPersistenceListener(persistenceListener.configure(this.config));
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)("PersistenceListener class '" + string + "' not found. Check your configuration."), (Throwable)classNotFoundException);
        }
        catch (Exception exception) {
            log.error((Object)("Error instantiating class '" + string + "'"), (Throwable)exception);
        }
        return cache;
    }

    protected Cache configureStandardListeners(Cache cache) {
        if (this.config.getProperty(PERSISTENCE_CLASS_KEY) != null) {
            cache = this.setPersistenceListener(cache);
        }
        if (this.config.getProperty(CACHE_ENTRY_EVENT_LISTENERS_KEY) != null) {
            CacheEventListener[] cacheEventListenerArray = this.getCacheEventListeners();
            for (int i = 0; i < cacheEventListenerArray.length; ++i) {
                if (cacheEventListenerArray[i] instanceof LifecycleAware) {
                    try {
                        ((LifecycleAware)((Object)cacheEventListenerArray[i])).initialize(cache, this.config);
                    }
                    catch (InitializationException initializationException) {
                        log.error((Object)("Could not initialize listener '" + cacheEventListenerArray[i].getClass().getName() + "'. Listener ignored."), (Throwable)initializationException);
                        continue;
                    }
                }
                if (cacheEventListenerArray[i] instanceof CacheEntryEventListener) {
                    cache.addCacheEventListener(cacheEventListenerArray[i], class$com$opensymphony$oscache$base$events$CacheEntryEventListener == null ? AbstractCacheAdministrator.class$("com.opensymphony.oscache.base.events.CacheEntryEventListener") : class$com$opensymphony$oscache$base$events$CacheEntryEventListener);
                }
                if (!(cacheEventListenerArray[i] instanceof CacheMapAccessEventListener)) continue;
                cache.addCacheEventListener(cacheEventListenerArray[i], class$com$opensymphony$oscache$base$events$CacheMapAccessEventListener == null ? AbstractCacheAdministrator.class$("com.opensymphony.oscache.base.events.CacheMapAccessEventListener") : class$com$opensymphony$oscache$base$events$CacheMapAccessEventListener);
            }
        }
        return cache;
    }

    protected void finalizeListeners(Cache cache) {
        if (cache == null) {
            return;
        }
        Object[] objectArray = cache.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!(objectArray[i + 1] instanceof LifecycleAware)) continue;
            try {
                ((LifecycleAware)objectArray[i + 1]).finialize();
                continue;
            }
            catch (FinalizationException finalizationException) {
                log.error((Object)"Listener could not be finalized", (Throwable)finalizationException);
            }
        }
    }

    private void initCacheParameters() {
        this.algorithmClass = this.getProperty(CACHE_ALGORITHM_KEY);
        this.blocking = "true".equalsIgnoreCase(this.getProperty(CACHE_BLOCKING_KEY));
        String string = this.getProperty(CACHE_MEMORY_KEY);
        if (string != null && string.equalsIgnoreCase("false")) {
            this.memoryCaching = false;
        }
        this.unlimitedDiskCache = Boolean.valueOf(this.config.getProperty(CACHE_DISK_UNLIMITED_KEY));
        this.overflowPersistence = Boolean.valueOf(this.config.getProperty(CACHE_PERSISTENCE_OVERFLOW_KEY));
        String string2 = this.getProperty(CACHE_CAPACITY_KEY);
        try {
            if (string2 != null && string2.length() > 0) {
                this.cacheCapacity = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)("The value supplied for the cache capacity, '" + string2 + "', is not a valid number. The cache capacity setting is being ignored."));
        }
    }

    private void loadProps(Properties properties) {
        this.config = new Config(properties);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

