/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class WebUtils {
    public static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING_ATTRIBUTE = "javax.servlet.include.query_string";
    public static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH_ATTRIBUTE = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO_ATTRIBUTE = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING_ATTRIBUTE = "javax.servlet.forward.query_string";
    public static final String CONTENT_TYPE_CHARSET_PREFIX = ";charset=";
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    public static final String TEMP_DIR_CONTEXT_ATTRIBUTE = "javax.servlet.context.tempdir";
    public static final String HTML_ESCAPE_CONTEXT_PARAM = "defaultHtmlEscape";
    public static final String WEB_APP_ROOT_KEY_PARAM = "webAppRootKey";
    public static final String DEFAULT_WEB_APP_ROOT_KEY = "webapp.root";
    public static final String[] SUBMIT_IMAGE_SUFFIXES = new String[]{".x", ".y"};
    public static final String SESSION_MUTEX_ATTRIBUTE = (class$org$springframework$web$util$WebUtils == null ? (class$org$springframework$web$util$WebUtils = WebUtils.class$("org.springframework.web.util.WebUtils")) : class$org$springframework$web$util$WebUtils).getName() + ".MUTEX";
    static /* synthetic */ Class class$org$springframework$web$util$WebUtils;

    public static void setWebAppRootSystemProperty(ServletContext servletContext) throws IllegalStateException {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        String string = servletContext.getRealPath("/");
        if (string == null) {
            throw new IllegalStateException("Cannot set web app root system property when WAR file is not expanded");
        }
        String string2 = servletContext.getInitParameter(WEB_APP_ROOT_KEY_PARAM);
        String string3 = string2 != null ? string2 : DEFAULT_WEB_APP_ROOT_KEY;
        String string4 = System.getProperty(string3);
        if (string4 != null && !StringUtils.pathEquals((String)string4, (String)string)) {
            throw new IllegalStateException("Web app root system property already set to different value: '" + string3 + "' = [" + string4 + "] instead of [" + string + "] - " + "Choose unique values for the 'webAppRootKey' context-param in your web.xml files!");
        }
        System.setProperty(string3, string);
        servletContext.log("Set web app root system property: '" + string3 + "' = [" + string + "]");
    }

    public static void removeWebAppRootSystemProperty(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        String string = servletContext.getInitParameter(WEB_APP_ROOT_KEY_PARAM);
        String string2 = string != null ? string : DEFAULT_WEB_APP_ROOT_KEY;
        System.getProperties().remove(string2);
    }

    public static boolean isDefaultHtmlEscape(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        String string = servletContext.getInitParameter(HTML_ESCAPE_CONTEXT_PARAM);
        return Boolean.valueOf(string);
    }

    public static File getTempDir(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        return (File)servletContext.getAttribute(TEMP_DIR_CONTEXT_ATTRIBUTE);
    }

    public static String getRealPath(ServletContext servletContext, String string) throws FileNotFoundException {
        String string2;
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if ((string2 = servletContext.getRealPath(string)) == null) {
            throw new FileNotFoundException("ServletContext resource [" + string + "] cannot be resolved to absolute file path - " + "web application archive not expanded?");
        }
        return string2;
    }

    public static String getSessionId(HttpServletRequest httpServletRequest) {
        Assert.notNull((Object)httpServletRequest, (String)"Request must not be null");
        HttpSession httpSession = httpServletRequest.getSession(false);
        return httpSession != null ? httpSession.getId() : null;
    }

    public static Object getSessionAttribute(HttpServletRequest httpServletRequest, String string) {
        Assert.notNull((Object)httpServletRequest, (String)"Request must not be null");
        HttpSession httpSession = httpServletRequest.getSession(false);
        return httpSession != null ? httpSession.getAttribute(string) : null;
    }

    public static Object getRequiredSessionAttribute(HttpServletRequest httpServletRequest, String string) throws IllegalStateException {
        Object object = WebUtils.getSessionAttribute(httpServletRequest, string);
        if (object == null) {
            throw new IllegalStateException("No session attribute '" + string + "' found");
        }
        return object;
    }

    public static void setSessionAttribute(HttpServletRequest httpServletRequest, String string, Object object) {
        Assert.notNull((Object)httpServletRequest, (String)"Request must not be null");
        if (object != null) {
            httpServletRequest.getSession().setAttribute(string, object);
        } else {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                httpSession.removeAttribute(string);
            }
        }
    }

    public static Object getOrCreateSessionAttribute(HttpSession httpSession, String string, Class clazz) throws IllegalArgumentException {
        Assert.notNull((Object)httpSession, (String)"Session must not be null");
        Object object = httpSession.getAttribute(string);
        if (object == null) {
            try {
                object = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException("Could not instantiate class [" + clazz.getName() + "] for session attribute '" + string + "': " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Could not access default constructor of class [" + clazz.getName() + "] for session attribute '" + string + "': " + illegalAccessException.getMessage());
            }
            httpSession.setAttribute(string, object);
        }
        return object;
    }

    public static Object getSessionMutex(HttpSession httpSession) {
        Assert.notNull((Object)httpSession, (String)"Session must not be null");
        Object object = httpSession.getAttribute(SESSION_MUTEX_ATTRIBUTE);
        if (object == null) {
            object = httpSession;
        }
        return object;
    }

    public static boolean isIncludeRequest(ServletRequest servletRequest) {
        return servletRequest.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null;
    }

    public static void exposeForwardRequestAttributes(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute(FORWARD_REQUEST_URI_ATTRIBUTE) == null) {
            httpServletRequest.setAttribute(FORWARD_REQUEST_URI_ATTRIBUTE, (Object)httpServletRequest.getRequestURI());
        }
        if (httpServletRequest.getAttribute(FORWARD_CONTEXT_PATH_ATTRIBUTE) == null) {
            httpServletRequest.setAttribute(FORWARD_CONTEXT_PATH_ATTRIBUTE, (Object)httpServletRequest.getContextPath());
        }
        if (httpServletRequest.getAttribute(FORWARD_SERVLET_PATH_ATTRIBUTE) == null) {
            httpServletRequest.setAttribute(FORWARD_SERVLET_PATH_ATTRIBUTE, (Object)httpServletRequest.getServletPath());
        }
        if (httpServletRequest.getAttribute(FORWARD_PATH_INFO_ATTRIBUTE) == null) {
            httpServletRequest.setAttribute(FORWARD_PATH_INFO_ATTRIBUTE, (Object)httpServletRequest.getPathInfo());
        }
        if (httpServletRequest.getAttribute(FORWARD_QUERY_STRING_ATTRIBUTE) == null) {
            httpServletRequest.setAttribute(FORWARD_QUERY_STRING_ATTRIBUTE, (Object)httpServletRequest.getQueryString());
        }
    }

    public static void exposeRequestAttributes(ServletRequest servletRequest, Map map) throws IllegalArgumentException {
        Assert.notNull((Object)servletRequest, (String)"Request must not be null");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Invalid key [" + entry.getKey() + "] in attributes Map - only Strings allowed as attribute keys");
            }
            servletRequest.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    public static Cookie getCookie(HttpServletRequest httpServletRequest, String string) {
        Assert.notNull((Object)httpServletRequest, (String)"Request must not be null");
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                return cookieArray[i];
            }
        }
        return null;
    }

    public static boolean hasSubmitParameter(ServletRequest servletRequest, String string) {
        Assert.notNull((Object)servletRequest, (String)"Request must not be null");
        if (servletRequest.getParameter(string) != null) {
            return true;
        }
        for (int i = 0; i < SUBMIT_IMAGE_SUFFIXES.length; ++i) {
            String string2 = SUBMIT_IMAGE_SUFFIXES[i];
            if (servletRequest.getParameter(string + string2) == null) continue;
            return true;
        }
        return false;
    }

    public static Map getParametersStartingWith(ServletRequest servletRequest, String string) {
        Assert.notNull((Object)servletRequest, (String)"Request must not be null");
        Enumeration enumeration = servletRequest.getParameterNames();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        if (string == null) {
            string = "";
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!"".equals(string) && !string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length());
            String[] stringArray = servletRequest.getParameterValues(string2);
            if (stringArray == null || stringArray.length == 0) continue;
            if (stringArray.length > 1) {
                treeMap.put(string3, stringArray);
                continue;
            }
            treeMap.put(string3, stringArray[0]);
        }
        return treeMap;
    }

    public static String extractFilenameFromUrlPath(String string) {
        String string2;
        int n;
        int n2 = string.lastIndexOf(47) + 1;
        int n3 = string.indexOf(59);
        if (n3 == -1 && (n3 = string.indexOf(63)) == -1) {
            n3 = string.length();
        }
        if ((n = (string2 = string.substring(n2, n3)).lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

