/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.util.StringUtils;

public class UrlPathHelper {
    public static final String INCLUDE_URI_REQUEST_ATTRIBUTE = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_REQUEST_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_REQUEST_ATTRIBUTE = "javax.servlet.include.servlet_path";
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean alwaysUseFullPath = false;
    private boolean urlDecode = false;
    private String defaultEncoding = "ISO-8859-1";

    public void setAlwaysUseFullPath(boolean bl) {
        this.alwaysUseFullPath = bl;
    }

    public void setUrlDecode(boolean bl) {
        this.urlDecode = bl;
    }

    public void setDefaultEncoding(String string) {
        this.defaultEncoding = string;
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getLookupPathForRequest(HttpServletRequest httpServletRequest) {
        if (this.alwaysUseFullPath) {
            return this.getPathWithinApplication(httpServletRequest);
        }
        String string = this.getPathWithinServletMapping(httpServletRequest);
        if (!"".equals(string)) {
            return string;
        }
        return this.getPathWithinApplication(httpServletRequest);
    }

    public String getPathWithinServletMapping(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = this.getPathWithinApplication(httpServletRequest);
        if (string2.startsWith(string = this.getServletPath(httpServletRequest))) {
            return string2.substring(string.length());
        }
        return string;
    }

    public String getPathWithinApplication(HttpServletRequest httpServletRequest) {
        String string = this.getContextPath(httpServletRequest);
        String string2 = this.getRequestUri(httpServletRequest);
        if (StringUtils.startsWithIgnoreCase((String)string2, (String)string)) {
            String string3 = string2.substring(string.length());
            return StringUtils.hasText((String)string3) ? string3 : "/";
        }
        return string2;
    }

    public String getRequestUri(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(INCLUDE_URI_REQUEST_ATTRIBUTE);
        if (string == null) {
            string = httpServletRequest.getRequestURI();
        }
        return this.decodeAndCleanUriString(httpServletRequest, string);
    }

    public String getContextPath(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(INCLUDE_CONTEXT_PATH_REQUEST_ATTRIBUTE);
        if (string == null) {
            string = httpServletRequest.getContextPath();
        }
        return this.decodeRequestString(httpServletRequest, string);
    }

    public String getServletPath(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(INCLUDE_SERVLET_PATH_REQUEST_ATTRIBUTE);
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        return string;
    }

    public String getOriginatingRequestUri(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.forward.request_uri");
        if (string == null) {
            string = httpServletRequest.getRequestURI();
        }
        return this.decodeAndCleanUriString(httpServletRequest, string);
    }

    public String getOriginatingContextPath(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.forward.context_path");
        if (string == null) {
            string = httpServletRequest.getContextPath();
        }
        return this.decodeRequestString(httpServletRequest, string);
    }

    public String getOriginatingQueryString(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.forward.query_string");
        if (string == null) {
            string = httpServletRequest.getQueryString();
        }
        return string;
    }

    private String decodeAndCleanUriString(HttpServletRequest httpServletRequest, String string) {
        int n = (string = this.decodeRequestString(httpServletRequest, string)).indexOf(59);
        return n != -1 ? string.substring(0, n) : string;
    }

    public String decodeRequestString(HttpServletRequest httpServletRequest, String string) {
        if (this.urlDecode) {
            String string2 = this.determineEncoding(httpServletRequest);
            try {
                if (JdkVersion.getMajorJavaVersion() < 1) {
                    throw new UnsupportedEncodingException("JDK 1.3 URLDecoder does not support custom encoding");
                }
                return URLDecoder.decode(string, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Could not decode request string [" + string + "] with encoding '" + string2 + "': falling back to platform default encoding; exception message: " + unsupportedEncodingException.getMessage()));
                }
                return URLDecoder.decode(string);
            }
        }
        return string;
    }

    protected String determineEncoding(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getCharacterEncoding();
        if (string == null) {
            string = this.getDefaultEncoding();
        }
        return string;
    }
}

