/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import javax.servlet.jsp.tagext.Tag;
import org.springframework.util.Assert;

public abstract class TagUtils {
    public static final String SCOPE_PAGE = "page";
    public static final String SCOPE_REQUEST = "request";
    public static final String SCOPE_SESSION = "session";
    public static final String SCOPE_APPLICATION = "application";
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$Tag;

    public static int getScope(String string) {
        Assert.notNull((Object)string, (String)"Scope to search for cannot be null");
        if (string.equals(SCOPE_REQUEST)) {
            return 2;
        }
        if (string.equals(SCOPE_SESSION)) {
            return 3;
        }
        if (string.equals(SCOPE_APPLICATION)) {
            return 4;
        }
        return 1;
    }

    public static boolean hasAncestorOfType(Tag tag, Class clazz) {
        Assert.notNull((Object)tag, (String)"Tag cannot be null");
        Assert.notNull((Object)clazz, (String)"Ancestor tag class cannot be null");
        if (!(class$javax$servlet$jsp$tagext$Tag == null ? (class$javax$servlet$jsp$tagext$Tag = TagUtils.class$("javax.servlet.jsp.tagext.Tag")) : class$javax$servlet$jsp$tagext$Tag).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class '" + clazz.getName() + "' is not a valid Tag type");
        }
        for (Tag tag2 = tag.getParent(); tag2 != null; tag2 = tag2.getParent()) {
            if (!clazz.isAssignableFrom(tag2.getClass())) continue;
            return true;
        }
        return false;
    }

    public static void assertHasAncestorOfType(Tag tag, Class clazz, String string, String string2) {
        Assert.hasText((String)string, (String)"'tagName' must not be empty");
        Assert.hasText((String)string2, (String)"'ancestorTagName' must not be empty");
        if (!TagUtils.hasAncestorOfType(tag, clazz)) {
            throw new IllegalStateException("The '" + string + "' tag can only be used inside a valid '" + string2 + "' tag.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

