/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.springframework.util.Log4jConfigurer;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.util.WebUtils;

public abstract class Log4jWebConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "log4jConfigLocation";
    public static final String REFRESH_INTERVAL_PARAM = "log4jRefreshInterval";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "log4jExposeWebAppRoot";

    public static void initLogging(ServletContext servletContext) {
        block8: {
            String string;
            if (Log4jWebConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.setWebAppRootSystemProperty(servletContext);
            }
            if ((string = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
                try {
                    if (!ResourceUtils.isUrl((String)string)) {
                        string = SystemPropertyUtils.resolvePlaceholders((String)string);
                        string = WebUtils.getRealPath(servletContext, string);
                    }
                    servletContext.log("Initializing Log4J from [" + string + "]");
                    String string2 = servletContext.getInitParameter(REFRESH_INTERVAL_PARAM);
                    if (string2 != null) {
                        try {
                            long l = Long.parseLong(string2);
                            Log4jConfigurer.initLogging((String)string, (long)l);
                            break block8;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Invalid 'log4jRefreshInterval' parameter: " + numberFormatException.getMessage());
                        }
                    }
                    Log4jConfigurer.initLogging((String)string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IllegalArgumentException("Invalid 'log4jConfigLocation' parameter: " + fileNotFoundException.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownLogging(ServletContext servletContext) {
        servletContext.log("Shutting down Log4J");
        try {
            Log4jConfigurer.shutdownLogging();
        }
        finally {
            if (Log4jWebConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.removeWebAppRootSystemProperty(servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String string = servletContext.getInitParameter(EXPOSE_WEB_APP_ROOT_PARAM);
        return string == null || Boolean.valueOf(string) != false;
    }
}

