/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import org.springframework.web.util.HtmlCharacterEntityDecoder;
import org.springframework.web.util.HtmlCharacterEntityReferences;

public abstract class HtmlUtils {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String htmlEscape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = characterEntityReferences.convertToReference(c);
            if (string2 != null) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String htmlEscapeDecimal(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (characterEntityReferences.isMappedToReference(c)) {
                stringBuffer.append("&#");
                stringBuffer.append((int)c);
                stringBuffer.append(';');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String htmlEscapeHex(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (characterEntityReferences.isMappedToReference(c)) {
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toString(c, 16));
                stringBuffer.append(';');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String htmlUnescape(String string) {
        if (string == null) {
            return null;
        }
        return new HtmlCharacterEntityDecoder(characterEntityReferences, string).decode();
    }
}

