/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.Assert;

class HtmlCharacterEntityReferences {
    static final char REFERENCE_START = '&';
    static final String DECIMAL_REFERENCE_START = "&#";
    static final String HEX_REFERENCE_START = "&#x";
    static final char REFERENCE_END = ';';
    static final char CHAR_NULL = '\uffff';
    private static final String PROPERTIES_FILE = "HtmlCharacterEntityReferences.properties";
    private final String[] characterToEntityReferenceMap = new String[3000];
    private final Map entityReferenceToCharacterMap = new HashMap(252);
    static /* synthetic */ Class class$org$springframework$web$util$HtmlCharacterEntityReferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HtmlCharacterEntityReferences() {
        Properties properties = new Properties();
        InputStream inputStream = (class$org$springframework$web$util$HtmlCharacterEntityReferences == null ? (class$org$springframework$web$util$HtmlCharacterEntityReferences = HtmlCharacterEntityReferences.class$("org.springframework.web.util.HtmlCharacterEntityReferences")) : class$org$springframework$web$util$HtmlCharacterEntityReferences).getResourceAsStream(PROPERTIES_FILE);
        if (inputStream == null) {
            throw new IllegalStateException("Cannot find reference definition file [HtmlCharacterEntityReferences.properties] as class path resource");
        }
        try {
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to parse reference definition file [HtmlCharacterEntityReferences.properties]: " + iOException.getMessage());
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = Integer.parseInt(string);
            Assert.isTrue((n < 1000 || n >= 8000 && n < 10000 ? 1 : 0) != 0, (String)("Invalid reference to special HTML entity: " + n));
            int n2 = n < 1000 ? n : n - 7000;
            String string2 = properties.getProperty(string);
            this.characterToEntityReferenceMap[n2] = '&' + string2 + ';';
            this.entityReferenceToCharacterMap.put(string2, new Character((char)n));
        }
    }

    public int getSupportedReferenceCount() {
        return this.entityReferenceToCharacterMap.size();
    }

    public boolean isMappedToReference(char c) {
        return this.convertToReference(c) != null;
    }

    public String convertToReference(char n) {
        int n2;
        String string;
        if ((n < 1000 || n >= 8000 && n < 10000) && (string = this.characterToEntityReferenceMap[n2 = n < 1000 ? n : n - 7000]) != null) {
            return string;
        }
        return null;
    }

    public char convertToCharacter(String string) {
        Character c = (Character)this.entityReferenceToCharacterMap.get(string);
        if (c != null) {
            return c.charValue();
        }
        return '\uffff';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

