/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import org.springframework.web.util.HtmlCharacterEntityReferences;

class HtmlCharacterEntityDecoder {
    private static final int MAX_REFERENCE_SIZE = 10;
    private final HtmlCharacterEntityReferences characterEntityReferences;
    private final String originalMessage;
    private final StringBuffer decodedMessage;
    private int currentPosition = 0;
    private int nextPotentialReferencePosition = -1;
    private int nextSemicolonPosition = -2;

    public HtmlCharacterEntityDecoder(HtmlCharacterEntityReferences htmlCharacterEntityReferences, String string) {
        this.characterEntityReferences = htmlCharacterEntityReferences;
        this.originalMessage = string;
        this.decodedMessage = new StringBuffer(this.originalMessage.length());
    }

    public String decode() {
        while (this.currentPosition < this.originalMessage.length()) {
            this.findNextPotentialReference(this.currentPosition);
            this.copyCharactersTillPotentialReference();
            this.processPossibleReference();
        }
        return this.decodedMessage.toString();
    }

    private void findNextPotentialReference(int n) {
        this.nextPotentialReferencePosition = Math.max(n, this.nextSemicolonPosition - 10);
        do {
            boolean bl;
            this.nextPotentialReferencePosition = this.originalMessage.indexOf(38, this.nextPotentialReferencePosition);
            if (this.nextSemicolonPosition != -1 && this.nextSemicolonPosition < this.nextPotentialReferencePosition) {
                this.nextSemicolonPosition = this.originalMessage.indexOf(59, this.nextPotentialReferencePosition + 1);
            }
            boolean bl2 = bl = this.nextPotentialReferencePosition != -1 && this.nextSemicolonPosition != -1 && this.nextPotentialReferencePosition - this.nextSemicolonPosition < 10;
            if (bl || this.nextPotentialReferencePosition == -1) break;
            if (this.nextSemicolonPosition == -1) {
                this.nextPotentialReferencePosition = -1;
                break;
            }
            ++this.nextPotentialReferencePosition;
        } while (this.nextPotentialReferencePosition != -1);
    }

    private void copyCharactersTillPotentialReference() {
        if (this.nextPotentialReferencePosition != this.currentPosition) {
            int n;
            int n2 = n = this.nextPotentialReferencePosition != -1 ? this.nextPotentialReferencePosition : this.originalMessage.length();
            if (n - this.currentPosition > 3) {
                this.decodedMessage.append(this.originalMessage.substring(this.currentPosition, n));
                this.currentPosition = n;
            } else {
                while (this.currentPosition < n) {
                    this.decodedMessage.append(this.originalMessage.charAt(this.currentPosition++));
                }
            }
        }
    }

    private void processPossibleReference() {
        if (this.nextPotentialReferencePosition != -1) {
            boolean bl;
            boolean bl2 = this.originalMessage.charAt(this.currentPosition + 1) == '#';
            boolean bl3 = bl = bl2 ? this.processNumberedReference() : this.processNamedReference();
            if (bl) {
                this.currentPosition = this.nextSemicolonPosition + 1;
            } else {
                char c = this.originalMessage.charAt(this.currentPosition);
                this.decodedMessage.append(c);
                ++this.currentPosition;
            }
        }
    }

    private boolean processNumberedReference() {
        boolean bl = this.originalMessage.charAt(this.nextPotentialReferencePosition + 2) == 'x' || this.originalMessage.charAt(this.nextPotentialReferencePosition + 2) == 'X';
        try {
            int n = !bl ? Integer.parseInt(this.getReferenceSubstring(2)) : Integer.parseInt(this.getReferenceSubstring(3), 16);
            this.decodedMessage.append((char)n);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean processNamedReference() {
        String string = this.getReferenceSubstring(1);
        char c = this.characterEntityReferences.convertToCharacter(string);
        if (c != '\uffff') {
            this.decodedMessage.append(c);
            return true;
        }
        return false;
    }

    private String getReferenceSubstring(int n) {
        return this.originalMessage.substring(this.nextPotentialReferencePosition + n, this.nextSemicolonPosition);
    }
}

