/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class ExpressionEvaluationUtils {
    public static final String EXPRESSION_CACHE_CONTEXT_PARAM = "cacheJspExpressions";
    public static final String EXPRESSION_PREFIX = "${";
    public static final String EXPRESSION_SUFFIX = "}";
    private static final String EXPRESSION_CACHE_FLAG_CONTEXT_ATTR = (class$org$springframework$web$util$ExpressionEvaluationUtils == null ? (class$org$springframework$web$util$ExpressionEvaluationUtils = ExpressionEvaluationUtils.class$("org.springframework.web.util.ExpressionEvaluationUtils")) : class$org$springframework$web$util$ExpressionEvaluationUtils).getName() + ".CACHE_JSP_EXPRESSIONS";
    private static final String EXPRESSION_CACHE_MAP_CONTEXT_ATTR = (class$org$springframework$web$util$ExpressionEvaluationUtils == null ? (class$org$springframework$web$util$ExpressionEvaluationUtils = ExpressionEvaluationUtils.class$("org.springframework.web.util.ExpressionEvaluationUtils")) : class$org$springframework$web$util$ExpressionEvaluationUtils).getName() + ".JSP_EXPRESSION_CACHE";
    private static final String JSP_20_CLASS_NAME = "javax.servlet.jsp.el.ExpressionEvaluator";
    private static final String JAKARTA_JSTL_CLASS_NAME = "org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$util$ExpressionEvaluationUtils == null ? (class$org$springframework$web$util$ExpressionEvaluationUtils = ExpressionEvaluationUtils.class$("org.springframework.web.util.ExpressionEvaluationUtils")) : class$org$springframework$web$util$ExpressionEvaluationUtils));
    private static ExpressionEvaluationHelper helper;
    static /* synthetic */ Class class$org$springframework$web$util$ExpressionEvaluationUtils;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static boolean isExpressionLanguage(String string) {
        return string != null && string.indexOf(EXPRESSION_PREFIX) != -1;
    }

    public static Object evaluate(String string, String string2, Class clazz, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(string2)) {
            return ExpressionEvaluationUtils.doEvaluate(string, string2, clazz, pageContext);
        }
        if (string2 != null && clazz != null && !clazz.isInstance(string2)) {
            throw new JspException("Attribute value \"" + string2 + "\" is neither a JSP EL expression nor " + "assignable to result class [" + clazz.getName() + "]");
        }
        return string2;
    }

    public static Object evaluate(String string, String string2, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(string2)) {
            return ExpressionEvaluationUtils.doEvaluate(string, string2, class$java$lang$Object == null ? (class$java$lang$Object = ExpressionEvaluationUtils.class$("java.lang.Object")) : class$java$lang$Object, pageContext);
        }
        return string2;
    }

    public static String evaluateString(String string, String string2, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(string2)) {
            return (String)ExpressionEvaluationUtils.doEvaluate(string, string2, class$java$lang$String == null ? (class$java$lang$String = ExpressionEvaluationUtils.class$("java.lang.String")) : class$java$lang$String, pageContext);
        }
        return string2;
    }

    public static int evaluateInteger(String string, String string2, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(string2)) {
            return (Integer)ExpressionEvaluationUtils.doEvaluate(string, string2, class$java$lang$Integer == null ? (class$java$lang$Integer = ExpressionEvaluationUtils.class$("java.lang.Integer")) : class$java$lang$Integer, pageContext);
        }
        return Integer.parseInt(string2);
    }

    public static boolean evaluateBoolean(String string, String string2, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(string2)) {
            return (Boolean)ExpressionEvaluationUtils.doEvaluate(string, string2, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ExpressionEvaluationUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, pageContext);
        }
        return Boolean.valueOf(string2);
    }

    private static Object doEvaluate(String string, String string2, Class clazz, PageContext pageContext) throws JspException {
        Assert.notNull((Object)string2, (String)"Attribute value must not be null");
        Assert.notNull((Object)clazz, (String)"Result class must not be null");
        Assert.notNull((Object)pageContext, (String)"PageContext must not be null");
        if (clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = ExpressionEvaluationUtils.class$("java.lang.String")) : class$java$lang$String)) {
            StringBuffer stringBuffer = null;
            int n = -1;
            int n2 = 0;
            do {
                if ((n = string2.indexOf(EXPRESSION_PREFIX, n2)) != -1) {
                    int n3 = n2;
                    n2 = string2.indexOf(EXPRESSION_SUFFIX, n + EXPRESSION_PREFIX.length());
                    String string3 = null;
                    string3 = n2 != -1 ? string2.substring(n, n2 += EXPRESSION_SUFFIX.length()) : string2.substring(n);
                    if (string3.length() == string2.length()) {
                        return helper.evaluate(string, string2, clazz, pageContext);
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(string2.substring(n3, n));
                    stringBuffer.append(helper.evaluate(string, string3, class$java$lang$String == null ? ExpressionEvaluationUtils.class$("java.lang.String") : class$java$lang$String, pageContext));
                    continue;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string2.substring(n2));
            } while (n != -1 && n2 != -1);
            return stringBuffer.toString();
        }
        return helper.evaluate(string, string2, clazz, pageContext);
    }

    private static Map getJspExpressionCache(PageContext pageContext) {
        ServletContext servletContext = pageContext.getServletContext();
        Map map = (Map)servletContext.getAttribute(EXPRESSION_CACHE_MAP_CONTEXT_ATTR);
        if (map == null) {
            Boolean bl = (Boolean)servletContext.getAttribute(EXPRESSION_CACHE_FLAG_CONTEXT_ATTR);
            if (bl == null) {
                bl = Boolean.valueOf(servletContext.getInitParameter(EXPRESSION_CACHE_CONTEXT_PARAM));
                servletContext.setAttribute(EXPRESSION_CACHE_FLAG_CONTEXT_ATTR, (Object)bl);
            }
            if (bl.booleanValue()) {
                map = Collections.synchronizedMap(new HashMap());
                servletContext.setAttribute(EXPRESSION_CACHE_MAP_CONTEXT_ATTR, map);
            }
        }
        return map;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ClassLoader classLoader = (class$org$springframework$web$util$ExpressionEvaluationUtils == null ? (class$org$springframework$web$util$ExpressionEvaluationUtils = ExpressionEvaluationUtils.class$("org.springframework.web.util.ExpressionEvaluationUtils")) : class$org$springframework$web$util$ExpressionEvaluationUtils).getClassLoader();
        if (ClassUtils.isPresent((String)JSP_20_CLASS_NAME, (ClassLoader)classLoader)) {
            logger.debug((Object)"Found JSP 2.0 ExpressionEvaluator");
            if (ClassUtils.isPresent((String)JAKARTA_JSTL_CLASS_NAME, (ClassLoader)classLoader)) {
                logger.debug((Object)"Found Jakarta JSTL ExpressionEvaluatorManager");
                helper = new Jsp20ExpressionEvaluationHelper(new JakartaExpressionEvaluationHelper());
            } else {
                helper = new Jsp20ExpressionEvaluationHelper(new NoExpressionEvaluationHelper());
            }
        } else if (ClassUtils.isPresent((String)JAKARTA_JSTL_CLASS_NAME, (ClassLoader)classLoader)) {
            logger.debug((Object)"Found Jakarta JSTL ExpressionEvaluatorManager");
            helper = new JakartaExpressionEvaluationHelper();
        } else {
            logger.debug((Object)"JSP expression evaluation not available");
            helper = new NoExpressionEvaluationHelper();
        }
    }

    private static class ExpressionCacheKey {
        private final String value;
        private final Class resultClass;
        private final int hashCode;

        public ExpressionCacheKey(String string, Class clazz) {
            this.value = string;
            this.resultClass = clazz;
            this.hashCode = this.value.hashCode() * 29 + this.resultClass.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExpressionCacheKey)) {
                return false;
            }
            ExpressionCacheKey expressionCacheKey = (ExpressionCacheKey)object;
            return this.value.equals(expressionCacheKey.value) && this.resultClass.equals(expressionCacheKey.resultClass);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static interface ExpressionEvaluationHelper {
        public Object evaluate(String var1, String var2, Class var3, PageContext var4) throws JspException;
    }

    private static class JakartaExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private JakartaExpressionEvaluationHelper() {
        }

        public Object evaluate(String string, String string2, Class clazz, PageContext pageContext) throws JspException {
            return ExpressionEvaluatorManager.evaluate((String)string, (String)string2, (Class)clazz, (PageContext)pageContext);
        }
    }

    private static class Jsp20ExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private final ExpressionEvaluationHelper fallback;
        private boolean fallbackNecessary = false;

        public Jsp20ExpressionEvaluationHelper(ExpressionEvaluationHelper expressionEvaluationHelper) {
            this.fallback = expressionEvaluationHelper;
        }

        public Object evaluate(String string, String string2, Class clazz, PageContext pageContext) throws JspException {
            if (this.isFallbackNecessary()) {
                return this.fallback.evaluate(string, string2, clazz, pageContext);
            }
            try {
                Map map = ExpressionEvaluationUtils.getJspExpressionCache(pageContext);
                if (map != null) {
                    ExpressionCacheKey expressionCacheKey = new ExpressionCacheKey(string2, clazz);
                    Expression expression = (Expression)map.get(expressionCacheKey);
                    if (expression == null) {
                        expression = pageContext.getExpressionEvaluator().parseExpression(string2, clazz, null);
                        map.put(expressionCacheKey, expression);
                    }
                    return expression.evaluate(pageContext.getVariableResolver());
                }
                return pageContext.getExpressionEvaluator().evaluate(string2, clazz, pageContext.getVariableResolver(), null);
            }
            catch (ELException eLException) {
                throw new JspException("Parsing of JSP EL expression \"" + string2 + "\" failed", (Throwable)eLException);
            }
            catch (LinkageError linkageError) {
                logger.debug((Object)"JSP 2.0 ExpressionEvaluator API present but not implemented - using fallback", (Throwable)linkageError);
                this.setFallbackNecessary();
                return this.fallback.evaluate(string, string2, clazz, pageContext);
            }
        }

        private synchronized boolean isFallbackNecessary() {
            return this.fallbackNecessary;
        }

        private synchronized void setFallbackNecessary() {
            this.fallbackNecessary = true;
        }
    }

    private static class NoExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private NoExpressionEvaluationHelper() {
        }

        public Object evaluate(String string, String string2, Class clazz, PageContext pageContext) throws JspException {
            throw new JspException("Neither JSP 2.0 nor Jakarta JSTL available - cannot parse JSP EL expression \"" + string2 + "\"");
        }
    }
}

