/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieGenerator {
    public static final String DEFAULT_COOKIE_PATH = "/";
    public static final int DEFAULT_COOKIE_MAX_AGE = Integer.MAX_VALUE;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String cookieName;
    private String cookieDomain;
    private String cookiePath = "/";
    private int cookieMaxAge = Integer.MAX_VALUE;
    private boolean cookieSecure = false;

    public void setCookieName(String string) {
        this.cookieName = string;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieDomain(String string) {
        this.cookieDomain = string;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookiePath(String string) {
        this.cookiePath = string;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookieMaxAge(int n) {
        this.cookieMaxAge = n;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieSecure(boolean bl) {
        this.cookieSecure = bl;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public void addCookie(HttpServletResponse httpServletResponse, String string) {
        Cookie cookie = this.createCookie(string);
        cookie.setMaxAge(this.getCookieMaxAge());
        if (this.isCookieSecure()) {
            cookie.setSecure(true);
        }
        httpServletResponse.addCookie(cookie);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added cookie with name [" + this.getCookieName() + "] and value [" + string + "]"));
        }
    }

    public void removeCookie(HttpServletResponse httpServletResponse) {
        Cookie cookie = this.createCookie("");
        cookie.setMaxAge(0);
        httpServletResponse.addCookie(cookie);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removed cookie with name [" + this.getCookieName() + "]"));
        }
    }

    protected Cookie createCookie(String string) {
        Cookie cookie = new Cookie(this.getCookieName(), string);
        if (this.getCookieDomain() != null) {
            cookie.setDomain(this.getCookieDomain());
        }
        cookie.setPath(this.getCookiePath());
        return cookie;
    }
}

