/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class MultipartFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_MULTIPART_RESOLVER_BEAN_NAME = "filterMultipartResolver";
    private String multipartResolverBeanName = "filterMultipartResolver";
    static /* synthetic */ Class class$org$springframework$web$multipart$MultipartResolver;

    public void setMultipartResolverBeanName(String string) {
        this.multipartResolverBeanName = string;
    }

    protected String getMultipartResolverBeanName() {
        return this.multipartResolverBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest httpServletRequest2;
        MultipartResolver multipartResolver = this.lookupMultipartResolver(httpServletRequest);
        if (multipartResolver.isMultipart(httpServletRequest2 = httpServletRequest)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving multipart request [" + httpServletRequest2.getRequestURI() + "] with MultipartFilter"));
            }
            httpServletRequest2 = multipartResolver.resolveMultipart(httpServletRequest2);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Request [" + httpServletRequest2.getRequestURI() + "] is not a multipart request"));
        }
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest2, (ServletResponse)httpServletResponse);
        }
        finally {
            if (httpServletRequest2 instanceof MultipartHttpServletRequest) {
                multipartResolver.cleanupMultipart((MultipartHttpServletRequest)httpServletRequest2);
            }
        }
    }

    protected MultipartResolver lookupMultipartResolver(HttpServletRequest httpServletRequest) {
        return this.lookupMultipartResolver();
    }

    protected MultipartResolver lookupMultipartResolver() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using MultipartResolver '" + this.getMultipartResolverBeanName() + "' for MultipartFilter"));
        }
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        return (MultipartResolver)webApplicationContext.getBean(this.getMultipartResolverBeanName(), class$org$springframework$web$multipart$MultipartResolver == null ? (class$org$springframework$web$multipart$MultipartResolver = MultipartFilter.class$("org.springframework.web.multipart.MultipartResolver")) : class$org$springframework$web$multipart$MultipartResolver);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

