/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class DefaultMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    private final Map multipartParameters;

    public DefaultMultipartHttpServletRequest(HttpServletRequest httpServletRequest, Map map, Map map2) {
        super(httpServletRequest);
        this.setMultipartFiles(map);
        this.multipartParameters = map2;
    }

    public Enumeration getParameterNames() {
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = super.getParameterNames();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        hashSet.addAll(this.multipartParameters.keySet());
        return Collections.enumeration(hashSet);
    }

    public String getParameter(String string) {
        String[] stringArray = (String[])this.multipartParameters.get(string);
        if (stringArray != null) {
            return stringArray.length > 0 ? stringArray[0] : null;
        }
        return super.getParameter(string);
    }

    public String[] getParameterValues(String string) {
        String[] stringArray = (String[])this.multipartParameters.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        return super.getParameterValues(string);
    }

    public Map getParameterMap() {
        HashMap hashMap = new HashMap();
        hashMap.putAll(super.getParameterMap());
        hashMap.putAll(this.multipartParameters);
        return hashMap;
    }
}

