/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.cos;

import com.oreilly.servlet.MultipartRequest;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.cos.CosMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class CosMultipartResolver
implements MultipartResolver,
ServletContextAware {
    public static final String MULTIPART_CONTENT_TYPE = "multipart/form-data";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int maxUploadSize = Integer.MAX_VALUE;
    private String defaultEncoding = "ISO-8859-1";
    private File uploadTempDir;

    public CosMultipartResolver() {
    }

    public CosMultipartResolver(ServletContext servletContext) {
        this.uploadTempDir = WebUtils.getTempDir(servletContext);
    }

    public void setMaxUploadSize(int n) {
        this.maxUploadSize = n;
    }

    protected int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setDefaultEncoding(String string) {
        this.defaultEncoding = string;
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setUploadTempDir(Resource resource) throws IOException {
        if (!resource.exists() && !resource.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + resource + "] could not be created");
        }
        this.uploadTempDir = resource.getFile();
    }

    protected File getUploadTempDir() {
        return this.uploadTempDir;
    }

    public void setServletContext(ServletContext servletContext) {
        if (this.uploadTempDir == null) {
            this.uploadTempDir = WebUtils.getTempDir(servletContext);
        }
    }

    public boolean isMultipart(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getContentType() != null && httpServletRequest.getContentType().startsWith(MULTIPART_CONTENT_TYPE);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest httpServletRequest) throws MultipartException {
        try {
            MultipartRequest multipartRequest = this.newMultipartRequest(httpServletRequest);
            if (this.logger.isDebugEnabled()) {
                Enumeration enumeration = multipartRequest.getFileNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    File file = multipartRequest.getFile(string);
                    this.logger.debug((Object)("Found multipart file '" + string + "' of size " + (file != null ? file.length() : 0L) + " bytes with original filename [" + multipartRequest.getOriginalFileName(string) + "], " + (file != null ? "stored at [" + file.getAbsolutePath() + "]" : "empty")));
                }
            }
            return new CosMultipartHttpServletRequest(httpServletRequest, multipartRequest);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().indexOf("exceeds limit") != -1) {
                throw new MaxUploadSizeExceededException(this.maxUploadSize, (Throwable)iOException);
            }
            throw new MultipartException("Could not parse multipart request", iOException);
        }
    }

    protected MultipartRequest newMultipartRequest(HttpServletRequest httpServletRequest) throws IOException {
        String string = this.uploadTempDir.getAbsolutePath();
        String string2 = this.determineEncoding(httpServletRequest);
        return new MultipartRequest(httpServletRequest, string, this.maxUploadSize, string2);
    }

    protected String determineEncoding(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getCharacterEncoding();
        if (string == null) {
            string = this.defaultEncoding;
        }
        return string;
    }

    public void cleanupMultipart(MultipartHttpServletRequest multipartHttpServletRequest) {
        MultipartRequest multipartRequest = ((CosMultipartHttpServletRequest)multipartHttpServletRequest).getMultipartRequest();
        Enumeration enumeration = multipartRequest.getFileNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            File file = multipartRequest.getFile(string);
            if (file == null) continue;
            if (file.exists()) {
                if (file.delete()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Cleaned up multipart file '" + string + "' with original filename [" + multipartRequest.getOriginalFileName(string) + "], stored at [" + file.getAbsolutePath() + "]"));
                    continue;
                }
                this.logger.warn((Object)("Could not delete multipart file '" + string + "' with original filename [" + multipartRequest.getOriginalFileName(string) + "], stored at [" + file.getAbsolutePath() + "]"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Multipart file '" + string + "' with original filename [" + multipartRequest.getOriginalFileName(string) + "] has already been moved - no cleanup necessary"));
        }
    }
}

