/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.cos;

import com.oreilly.servlet.MultipartRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class CosMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$multipart$cos$CosMultipartHttpServletRequest == null ? (class$org$springframework$web$multipart$cos$CosMultipartHttpServletRequest = CosMultipartHttpServletRequest.class$("org.springframework.web.multipart.cos.CosMultipartHttpServletRequest")) : class$org$springframework$web$multipart$cos$CosMultipartHttpServletRequest));
    private final MultipartRequest multipartRequest;
    static /* synthetic */ Class class$org$springframework$web$multipart$cos$CosMultipartHttpServletRequest;

    protected CosMultipartHttpServletRequest(HttpServletRequest httpServletRequest, MultipartRequest multipartRequest) {
        super(httpServletRequest);
        this.multipartRequest = multipartRequest;
        this.setMultipartFiles(this.initFileMap(multipartRequest));
    }

    public MultipartRequest getMultipartRequest() {
        return this.multipartRequest;
    }

    private Map initFileMap(MultipartRequest multipartRequest) {
        HashMap<String, CosMultipartFile> hashMap = new HashMap<String, CosMultipartFile>();
        Enumeration enumeration = multipartRequest.getFileNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashMap.put(string, new CosMultipartFile(string));
        }
        return hashMap;
    }

    public Enumeration getParameterNames() {
        return this.multipartRequest.getParameterNames();
    }

    public String getParameter(String string) {
        return this.multipartRequest.getParameter(string);
    }

    public String[] getParameterValues(String string) {
        return this.multipartRequest.getParameterValues(string);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashMap.put(string, this.getParameterValues(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CosMultipartFile
    implements MultipartFile {
        private final String name;
        private final File file;
        private final long size;

        public CosMultipartFile(String string) {
            this.name = string;
            this.file = CosMultipartHttpServletRequest.this.multipartRequest.getFile(this.name);
            this.size = this.file != null ? this.file.length() : 0L;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalFilename() {
            String string = CosMultipartHttpServletRequest.this.multipartRequest.getOriginalFileName(this.name);
            return string != null ? string : "";
        }

        public String getContentType() {
            return CosMultipartHttpServletRequest.this.multipartRequest.getContentType(this.name);
        }

        public boolean isEmpty() {
            return this.size == 0L;
        }

        public long getSize() {
            return this.size;
        }

        public byte[] getBytes() throws IOException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has been moved - cannot be read again");
            }
            return this.size > 0L ? FileCopyUtils.copyToByteArray((File)this.file) : new byte[]{};
        }

        public InputStream getInputStream() throws IOException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has been moved - cannot be read again");
            }
            if (this.size != 0L) {
                return new FileInputStream(this.file);
            }
            return new ByteArrayInputStream(new byte[0]);
        }

        public void transferTo(File file) throws IOException, IllegalStateException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has already been moved - cannot be transferred again");
            }
            if (file.exists() && !file.delete()) {
                throw new IOException("Destination file [" + file.getAbsolutePath() + "] already exists and could not be deleted");
            }
            boolean bl = false;
            if (this.file != null) {
                bl = this.file.renameTo(file);
                if (!bl) {
                    FileCopyUtils.copy((File)this.file, (File)file);
                }
            } else {
                file.createNewFile();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Multipart file '" + this.getName() + "' with original filename [" + this.getOriginalFilename() + "], stored " + (this.file != null ? "at [" + this.file.getAbsolutePath() + "]" : "in memory") + ": " + (bl ? "moved" : "copied") + " to [" + file.getAbsolutePath() + "]"));
            }
        }
    }
}

