/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class CommonsMultipartResolver
extends CommonsFileUploadSupport
implements MultipartResolver,
ServletContextAware {
    public CommonsMultipartResolver() {
    }

    public CommonsMultipartResolver(ServletContext servletContext) {
        this();
        this.setServletContext(servletContext);
    }

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        return new ServletFileUpload(fileItemFactory);
    }

    public void setServletContext(ServletContext servletContext) {
        if (!this.isUploadTempDirSpecified()) {
            this.getFileItemFactory().setRepository(WebUtils.getTempDir(servletContext));
        }
    }

    public boolean isMultipart(HttpServletRequest httpServletRequest) {
        return ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext(httpServletRequest));
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest httpServletRequest) throws MultipartException {
        String string = this.determineEncoding(httpServletRequest);
        FileUpload fileUpload = this.prepareFileUpload(string);
        try {
            List list = ((ServletFileUpload)fileUpload).parseRequest(httpServletRequest);
            CommonsFileUploadSupport.MultipartParsingResult multipartParsingResult = this.parseFileItems(list, string);
            return new DefaultMultipartHttpServletRequest(httpServletRequest, multipartParsingResult.getMultipartFiles(), multipartParsingResult.getMultipartParameters());
        }
        catch (FileUploadBase.SizeLimitExceededException sizeLimitExceededException) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)sizeLimitExceededException);
        }
        catch (FileUploadException fileUploadException) {
            throw new MultipartException("Could not parse multipart servlet request", fileUploadException);
        }
    }

    protected String determineEncoding(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getCharacterEncoding();
        if (string == null) {
            string = this.getDefaultEncoding();
        }
        return string;
    }

    public void cleanupMultipart(MultipartHttpServletRequest multipartHttpServletRequest) {
        this.cleanupFileItems(multipartHttpServletRequest.getFileMap().values());
    }
}

