/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartFile;

public class CommonsMultipartFile
implements MultipartFile,
Serializable {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$multipart$commons$CommonsMultipartFile == null ? (class$org$springframework$web$multipart$commons$CommonsMultipartFile = CommonsMultipartFile.class$("org.springframework.web.multipart.commons.CommonsMultipartFile")) : class$org$springframework$web$multipart$commons$CommonsMultipartFile));
    private final FileItem fileItem;
    private final long size;
    static /* synthetic */ Class class$org$springframework$web$multipart$commons$CommonsMultipartFile;

    public CommonsMultipartFile(FileItem fileItem) {
        this.fileItem = fileItem;
        this.size = this.fileItem.getSize();
    }

    public final FileItem getFileItem() {
        return this.fileItem;
    }

    public String getName() {
        return this.fileItem.getFieldName();
    }

    public String getOriginalFilename() {
        String string = this.fileItem.getName();
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf("/");
        if (n == -1) {
            n = string.lastIndexOf("\\");
        }
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public long getSize() {
        return this.size;
    }

    public byte[] getBytes() {
        if (!this.isAvailable()) {
            throw new IllegalStateException("File has been moved - cannot be read again");
        }
        byte[] byArray = this.fileItem.get();
        return byArray != null ? byArray : new byte[]{};
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isAvailable()) {
            throw new IllegalStateException("File has been moved - cannot be read again");
        }
        InputStream inputStream = this.fileItem.getInputStream();
        return inputStream != null ? inputStream : new ByteArrayInputStream(new byte[0]);
    }

    public void transferTo(File file) throws IOException, IllegalStateException {
        if (!this.isAvailable()) {
            throw new IllegalStateException("File has already been moved - cannot be transferred again");
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Destination file [" + file.getAbsolutePath() + "] already exists and could not be deleted");
        }
        try {
            this.fileItem.write(file);
            if (logger.isDebugEnabled()) {
                String string = "transferred";
                if (!this.fileItem.isInMemory()) {
                    string = this.isAvailable() ? "copied" : "moved";
                }
                logger.debug((Object)("Multipart file '" + this.getName() + "' with original filename [" + this.getOriginalFilename() + "], stored " + this.getStorageDescription() + ": " + string + " to [" + file.getAbsolutePath() + "]"));
            }
        }
        catch (FileUploadException fileUploadException) {
            throw new IllegalStateException(fileUploadException.getMessage());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            logger.error((Object)"Could not transfer to file", (Throwable)exception);
            throw new IOException("Could not transfer to file: " + exception.getMessage());
        }
    }

    protected boolean isAvailable() {
        if (this.fileItem.isInMemory()) {
            return true;
        }
        if (this.fileItem instanceof DiskFileItem) {
            return ((DiskFileItem)this.fileItem).getStoreLocation().exists();
        }
        return this.fileItem.getSize() == this.size;
    }

    public String getStorageDescription() {
        if (this.fileItem.isInMemory()) {
            return "in memory";
        }
        if (this.fileItem instanceof DiskFileItem) {
            return "at [" + ((DiskFileItem)this.fileItem).getStoreLocation().getAbsolutePath() + "]";
        }
        return "on disk";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

