/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public abstract class CommonsFileUploadSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final DiskFileItemFactory fileItemFactory = this.newFileItemFactory();
    private final FileUpload fileUpload = this.newFileUpload((FileItemFactory)this.getFileItemFactory());
    private boolean uploadTempDirSpecified = false;

    public DiskFileItemFactory getFileItemFactory() {
        return this.fileItemFactory;
    }

    public FileUpload getFileUpload() {
        return this.fileUpload;
    }

    public void setMaxUploadSize(long l) {
        this.fileUpload.setSizeMax(l);
    }

    public void setMaxInMemorySize(int n) {
        this.fileItemFactory.setSizeThreshold(n);
    }

    public void setDefaultEncoding(String string) {
        this.fileUpload.setHeaderEncoding(string);
    }

    protected String getDefaultEncoding() {
        String string = this.getFileUpload().getHeaderEncoding();
        if (string == null) {
            string = "ISO-8859-1";
        }
        return string;
    }

    public void setUploadTempDir(Resource resource) throws IOException {
        if (!resource.exists() && !resource.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + resource + "] could not be created");
        }
        this.fileItemFactory.setRepository(resource.getFile());
        this.uploadTempDirSpecified = true;
    }

    protected boolean isUploadTempDirSpecified() {
        return this.uploadTempDirSpecified;
    }

    protected DiskFileItemFactory newFileItemFactory() {
        return new DiskFileItemFactory();
    }

    protected abstract FileUpload newFileUpload(FileItemFactory var1);

    protected FileUpload prepareFileUpload(String string) {
        FileUpload fileUpload;
        FileUpload fileUpload2 = fileUpload = this.getFileUpload();
        if (string != null && !string.equals(fileUpload.getHeaderEncoding())) {
            fileUpload2 = this.newFileUpload((FileItemFactory)this.getFileItemFactory());
            fileUpload2.setSizeMax(fileUpload.getSizeMax());
            fileUpload2.setHeaderEncoding(string);
        }
        return fileUpload2;
    }

    protected MultipartParsingResult parseFileItems(List list, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            FileItem fileItem = (FileItem)iterator.next();
            if (fileItem.isFormField()) {
                String[] stringArray;
                object = null;
                if (string != null) {
                    try {
                        object = fileItem.getString(string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("Could not decode multipart item '" + fileItem.getFieldName() + "' with encoding '" + string + "': using platform default"));
                        }
                        object = fileItem.getString();
                    }
                } else {
                    object = fileItem.getString();
                }
                if ((stringArray = (String[])hashMap2.get(fileItem.getFieldName())) == null) {
                    hashMap2.put(fileItem.getFieldName(), new String[]{object});
                    continue;
                }
                String[] stringArray2 = StringUtils.addStringToArray((String[])stringArray, (String)object);
                hashMap2.put(fileItem.getFieldName(), stringArray2);
                continue;
            }
            object = new CommonsMultipartFile(fileItem);
            hashMap.put(((CommonsMultipartFile)object).getName(), object);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Found multipart file [" + ((CommonsMultipartFile)object).getName() + "] of size " + ((CommonsMultipartFile)object).getSize() + " bytes with original filename [" + ((CommonsMultipartFile)object).getOriginalFilename() + "], stored " + ((CommonsMultipartFile)object).getStorageDescription()));
        }
        return new MultipartParsingResult(hashMap, hashMap2);
    }

    protected void cleanupFileItems(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CommonsMultipartFile commonsMultipartFile = (CommonsMultipartFile)iterator.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleaning up multipart file [" + commonsMultipartFile.getName() + "] with original filename [" + commonsMultipartFile.getOriginalFilename() + "], stored " + commonsMultipartFile.getStorageDescription()));
            }
            commonsMultipartFile.getFileItem().delete();
        }
    }

    protected static class MultipartParsingResult {
        private final Map multipartFiles;
        private final Map multipartParameters;

        public MultipartParsingResult(Map map, Map map2) {
            this.multipartFiles = map;
            this.multipartParameters = map2;
        }

        public Map getMultipartFiles() {
            return this.multipartFiles;
        }

        public Map getMultipartParameters() {
            return this.multipartParameters;
        }
    }
}

