/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class WebApplicationContextVariableResolver
extends VariableResolver {
    public static final String WEB_APPLICATION_CONTEXT_VARIABLE_NAME = "webApplicationContext";
    protected final VariableResolver originalVariableResolver;

    public WebApplicationContextVariableResolver(VariableResolver variableResolver) {
        Assert.notNull((Object)variableResolver, (String)"Original JSF VariableResolver must not be null");
        this.originalVariableResolver = variableResolver;
    }

    protected final VariableResolver getOriginalVariableResolver() {
        return this.originalVariableResolver;
    }

    public Object resolveVariable(FacesContext facesContext, String string) throws EvaluationException {
        Object object = null;
        if (WEB_APPLICATION_CONTEXT_VARIABLE_NAME.equals(string)) {
            object = this.getWebApplicationContext(facesContext);
        }
        if (object == null) {
            object = this.getOriginalVariableResolver().resolveVariable(facesContext, string);
        }
        return object;
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getWebApplicationContext(facesContext);
    }
}

