/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.util.WebUtils;

public abstract class FacesContextUtils {
    public static WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        Assert.notNull((Object)facesContext, (String)"FacesContext must not be null");
        Object v = facesContext.getExternalContext().getApplicationMap().get(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (v == null) {
            return null;
        }
        if (v instanceof RuntimeException) {
            throw (RuntimeException)v;
        }
        if (v instanceof Error) {
            throw (Error)v;
        }
        if (!(v instanceof WebApplicationContext)) {
            throw new IllegalStateException("Root context attribute is not of type WebApplicationContext: " + v);
        }
        return (WebApplicationContext)v;
    }

    public static WebApplicationContext getRequiredWebApplicationContext(FacesContext facesContext) throws IllegalStateException {
        WebApplicationContext webApplicationContext = FacesContextUtils.getWebApplicationContext(facesContext);
        if (webApplicationContext == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return webApplicationContext;
    }

    public static Object getSessionMutex(FacesContext facesContext) {
        Assert.notNull((Object)facesContext, (String)"FacesContext must not be null");
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = externalContext.getSessionMap().get(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        if (object == null) {
            object = externalContext.getSession(true);
        }
        return object;
    }
}

