/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class DelegatingVariableResolver
extends VariableResolver {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final VariableResolver originalVariableResolver;

    public DelegatingVariableResolver(VariableResolver variableResolver) {
        Assert.notNull((Object)variableResolver, (String)"Original JSF VariableResolver must not be null");
        this.originalVariableResolver = variableResolver;
    }

    protected final VariableResolver getOriginalVariableResolver() {
        return this.originalVariableResolver;
    }

    public Object resolveVariable(FacesContext facesContext, String string) throws EvaluationException {
        BeanFactory beanFactory;
        Object object;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to resolve variable '" + string + "' in via original VariableResolver"));
        }
        if ((object = this.getOriginalVariableResolver().resolveVariable(facesContext, string)) != null) {
            return object;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to resolve variable '" + string + "' in root WebApplicationContext"));
        }
        if ((beanFactory = this.getBeanFactory(facesContext)).containsBean(string)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Successfully resolved variable '" + string + "' in root WebApplicationContext"));
            }
            return beanFactory.getBean(string);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Could not resolve variable '" + string + "'"));
        }
        return null;
    }

    protected BeanFactory getBeanFactory(FacesContext facesContext) {
        return this.getWebApplicationContext(facesContext);
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getRequiredWebApplicationContext(facesContext);
    }
}

