/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestContextFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        ServletRequestAttributes servletRequestAttributes = new ServletRequestAttributes(httpServletRequest);
        LocaleContextHolder.setLocale((Locale)httpServletRequest.getLocale());
        RequestContextHolder.setRequestAttributes(servletRequestAttributes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bound request context to thread: " + httpServletRequest));
        }
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            RequestContextHolder.setRequestAttributes(null);
            LocaleContextHolder.setLocale(null);
            servletRequestAttributes.requestCompleted();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleared thread-bound request context: " + httpServletRequest));
            }
        }
    }
}

