/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.GenericFilterBean;

public class DelegatingFilterProxy
extends GenericFilterBean {
    private String targetBeanName;
    private boolean targetFilterLifecycle = false;
    private Filter delegate;
    static /* synthetic */ Class class$javax$servlet$Filter;

    public void setTargetBeanName(String string) {
        this.targetBeanName = string;
    }

    protected String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetFilterLifecycle(boolean bl) {
        this.targetFilterLifecycle = bl;
    }

    protected boolean isTargetFilterLifecycle() {
        return this.targetFilterLifecycle;
    }

    protected void initFilterBean() throws ServletException {
        WebApplicationContext webApplicationContext;
        if (this.targetBeanName == null) {
            this.targetBeanName = this.getFilterName();
        }
        if ((webApplicationContext = WebApplicationContextUtils.getWebApplicationContext(this.getServletContext())) != null) {
            this.delegate = this.initDelegate(webApplicationContext);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.delegate == null) {
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
            this.delegate = this.initDelegate(webApplicationContext);
        }
        this.delegate.doFilter(servletRequest, servletResponse, filterChain);
    }

    public void destroy() {
        if (this.delegate != null) {
            this.destroyDelegate(this.delegate);
        }
    }

    protected Filter initDelegate(WebApplicationContext webApplicationContext) throws ServletException {
        Filter filter = (Filter)webApplicationContext.getBean(this.getTargetBeanName(), class$javax$servlet$Filter == null ? (class$javax$servlet$Filter = DelegatingFilterProxy.class$("javax.servlet.Filter")) : class$javax$servlet$Filter);
        if (this.isTargetFilterLifecycle()) {
            filter.init(this.getFilterConfig());
        }
        return filter;
    }

    protected void destroyDelegate(Filter filter) {
        if (this.isTargetFilterLifecycle()) {
            this.delegate.destroy();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

