/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class AbstractRequestLoggingFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_BEFORE_MESSAGE_PREFIX = "Before request [";
    public static final String DEFAULT_BEFORE_MESSAGE_SUFFIX = "]";
    public static final String DEFAULT_AFTER_MESSAGE_PREFIX = "After request [";
    public static final String DEFAULT_AFTER_MESSAGE_SUFFIX = "]";
    private boolean includeQueryString = false;
    private String beforeMessagePrefix = "Before request [";
    private String beforeMessageSuffix = "]";
    private String afterMessagePrefix = "After request [";
    private String afterMessageSuffix = "]";

    public void setIncludeQueryString(boolean bl) {
        this.includeQueryString = bl;
    }

    protected boolean isIncludeQueryString() {
        return this.includeQueryString;
    }

    public void setBeforeMessagePrefix(String string) {
        this.beforeMessagePrefix = string;
    }

    public void setBeforeMessageSuffix(String string) {
        this.beforeMessageSuffix = string;
    }

    public void setAfterMessagePrefix(String string) {
        this.afterMessagePrefix = string;
    }

    public void setAfterMessageSuffix(String string) {
        this.afterMessageSuffix = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        this.beforeRequest(httpServletRequest, this.getBeforeMessage(httpServletRequest));
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            this.afterRequest(httpServletRequest, this.getAfterMessage(httpServletRequest));
        }
    }

    private String getBeforeMessage(HttpServletRequest httpServletRequest) {
        return this.createMessage(httpServletRequest, this.beforeMessagePrefix, this.beforeMessageSuffix);
    }

    private String getAfterMessage(HttpServletRequest httpServletRequest) {
        return this.createMessage(httpServletRequest, this.afterMessagePrefix, this.afterMessageSuffix);
    }

    protected String createMessage(HttpServletRequest httpServletRequest, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(httpServletRequest.getRequestURI());
        if (this.isIncludeQueryString()) {
            stringBuffer.append('?');
            stringBuffer.append(httpServletRequest.getQueryString());
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    protected abstract void beforeRequest(HttpServletRequest var1, String var2);

    protected abstract void afterRequest(HttpServletRequest var1, String var2);
}

