/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;
import org.xml.sax.EntityResolver;

public class XmlWebApplicationContext
extends AbstractRefreshableWebApplicationContext {
    public static final String DEFAULT_CONFIG_LOCATION = "/WEB-INF/applicationContext.xml";
    public static final String DEFAULT_CONFIG_LOCATION_PREFIX = "/WEB-INF/";
    public static final String DEFAULT_CONFIG_LOCATION_SUFFIX = ".xml";

    protected void loadBeanDefinitions(DefaultListableBeanFactory defaultListableBeanFactory) throws IOException {
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)defaultListableBeanFactory);
        xmlBeanDefinitionReader.setResourceLoader((ResourceLoader)this);
        xmlBeanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this));
        this.initBeanDefinitionReader(xmlBeanDefinitionReader);
        this.loadBeanDefinitions(xmlBeanDefinitionReader);
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader xmlBeanDefinitionReader) throws BeansException, IOException {
        String[] stringArray = this.getConfigLocations();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                xmlBeanDefinitionReader.loadBeanDefinitions(stringArray[i]);
            }
        }
    }

    protected String[] getDefaultConfigLocations() {
        if (this.getNamespace() != null) {
            return new String[]{DEFAULT_CONFIG_LOCATION_PREFIX + this.getNamespace() + DEFAULT_CONFIG_LOCATION_SUFFIX};
        }
        return new String[]{DEFAULT_CONFIG_LOCATION};
    }
}

