/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.core.CollectionFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourceLoader;

public class ServletContextResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    public ServletContextResourcePatternResolver(ServletContext servletContext) {
        super((ResourceLoader)new ServletContextResourceLoader(servletContext));
    }

    public ServletContextResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Set doFindPathMatchingFileResources(Resource resource, String string) throws IOException {
        ServletContextResource servletContextResource;
        ServletContext servletContext;
        if (resource instanceof ServletContextResource && ((servletContext = (servletContextResource = (ServletContextResource)resource).getServletContext()).getMajorVersion() > 2 || servletContext.getMajorVersion() == 2 && servletContext.getMinorVersion() > 2)) {
            String string2 = servletContextResource.getPath() + string;
            Set set = CollectionFactory.createLinkedSetIfPossible((int)8);
            this.doRetrieveMatchingServletContextResources(servletContext, string2, servletContextResource.getPath(), set);
            return set;
        }
        return super.doFindPathMatchingFileResources(resource, string);
    }

    protected void doRetrieveMatchingServletContextResources(ServletContext servletContext, String string, String string2, Set set) throws IOException {
        Set set2 = servletContext.getResourcePaths(string2);
        if (set2 != null) {
            boolean bl = string.indexOf("**") != -1;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                int n;
                String string3 = (String)iterator.next();
                if (!string3.startsWith(string2) && (n = string3.indexOf(string2)) != -1) {
                    string3 = string3.substring(n);
                }
                if (string3.endsWith("/") && (bl || StringUtils.countOccurrencesOf((String)string3, (String)"/") < StringUtils.countOccurrencesOf((String)string, (String)"/"))) {
                    this.doRetrieveMatchingServletContextResources(servletContext, string, string3, set);
                }
                if (!this.getPathMatcher().match(string, string3)) continue;
                set.add(new ServletContextResource(servletContext, string3));
            }
        }
    }
}

