/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

public class ServletContextResource
extends AbstractResource {
    private final ServletContext servletContext;
    private final String path;

    public ServletContextResource(ServletContext servletContext, String string) {
        Assert.notNull((Object)servletContext, (String)"Cannot resolve ServletContextResource without ServletContext");
        this.servletContext = servletContext;
        Assert.notNull((Object)string, (String)"path is required");
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        this.path = StringUtils.cleanPath((String)string);
    }

    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    public final String getPath() {
        return this.path;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.servletContext.getResourceAsStream(this.path);
        if (inputStream == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return inputStream;
    }

    public URL getURL() throws IOException {
        URL uRL = this.servletContext.getResource(this.path);
        if (uRL == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return uRL;
    }

    public File getFile() throws IOException {
        String string = WebUtils.getRealPath(this.servletContext, this.path);
        return new File(string);
    }

    public Resource createRelative(String string) throws IOException {
        String string2 = StringUtils.applyRelativePath((String)this.path, (String)string);
        return new ServletContextResource(this.servletContext, string2);
    }

    public String getFilename() {
        return StringUtils.getFilename((String)this.path);
    }

    public String getDescription() {
        return "ServletContext resource [" + this.path + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ServletContextResource) {
            ServletContextResource servletContextResource = (ServletContextResource)((Object)object);
            return this.servletContext.equals(servletContextResource.servletContext) && this.path.equals(servletContextResource.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

