/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.Properties;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.web.context.ServletContextAware;

public class ServletContextPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements ServletContextAware {
    private boolean contextOverride = false;
    private boolean searchContextAttributes = false;
    private ServletContext servletContext;

    public void setContextOverride(boolean bl) {
        this.contextOverride = bl;
    }

    public void setSearchContextAttributes(boolean bl) {
        this.searchContextAttributes = bl;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected String resolvePlaceholder(String string, Properties properties) {
        String string2 = null;
        if (this.contextOverride && this.servletContext != null) {
            string2 = this.resolvePlaceholder(string, this.servletContext, this.searchContextAttributes);
        }
        if (string2 == null) {
            string2 = super.resolvePlaceholder(string, properties);
        }
        if (string2 == null && this.servletContext != null) {
            string2 = this.resolvePlaceholder(string, this.servletContext, this.searchContextAttributes);
        }
        return string2;
    }

    protected String resolvePlaceholder(String string, ServletContext servletContext, boolean bl) {
        Object object;
        String string2 = null;
        if (bl && (object = servletContext.getAttribute(string)) != null) {
            string2 = object.toString();
        }
        if (string2 == null) {
            string2 = servletContext.getInitParameter(string);
        }
        return string2;
    }
}

