/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;

public class ServletContextAwareProcessor
implements BeanPostProcessor {
    private ServletContext servletContext;
    private ServletConfig servletConfig;

    public ServletContextAwareProcessor(ServletContext servletContext) {
        this(servletContext, null);
    }

    public ServletContextAwareProcessor(ServletConfig servletConfig) {
        this(null, servletConfig);
    }

    public ServletContextAwareProcessor(ServletContext servletContext, ServletConfig servletConfig) {
        this.servletContext = servletContext;
        this.servletConfig = servletConfig;
        if (servletContext == null && servletConfig != null) {
            this.servletContext = servletConfig.getServletContext();
        }
    }

    public Object postProcessBeforeInitialization(Object object, String string) throws BeansException {
        if (this.servletContext != null && object instanceof ServletContextAware) {
            ((ServletContextAware)object).setServletContext(this.servletContext);
        }
        if (this.servletConfig != null && object instanceof ServletConfigAware) {
            ((ServletConfigAware)object).setServletConfig(this.servletConfig);
        }
        return object;
    }

    public Object postProcessAfterInitialization(Object object, String string) {
        return object;
    }
}

