/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ServletContextAware;

public class ServletContextAttributeExporter
implements ServletContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map attributes;

    public void setAttributes(Map map) {
        this.attributes = map;
    }

    public void setServletContext(ServletContext servletContext) {
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (this.logger.isWarnEnabled() && servletContext.getAttribute(string) != null) {
                this.logger.warn((Object)("Overwriting existing ServletContext attribute with name '" + string + "'"));
            }
            servletContext.setAttribute(string, entry.getValue());
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Exported ServletContext attribute with name '" + string + "'"));
        }
    }
}

