/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.context.ApplicationEvent;

public class RequestHandledEvent
extends ApplicationEvent {
    private String sessionId;
    private String userName;
    private final long processingTimeMillis;
    private Throwable failureCause;

    public RequestHandledEvent(Object object, String string, String string2, long l) {
        super(object);
        this.sessionId = string;
        this.userName = string2;
        this.processingTimeMillis = l;
    }

    public RequestHandledEvent(Object object, String string, String string2, long l, Throwable throwable) {
        this(object, string, string2, l);
        this.failureCause = throwable;
    }

    public long getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean wasFailure() {
        return this.failureCause != null;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("session=[").append(this.sessionId).append("]; ");
        stringBuffer.append("user=[").append(this.userName).append("]; ");
        return stringBuffer.toString();
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("session=[").append(this.sessionId).append("]; ");
        stringBuffer.append("user=[").append(this.userName).append("]; ");
        stringBuffer.append("time=[").append(this.processingTimeMillis).append("ms]; ");
        stringBuffer.append("status=[");
        if (!this.wasFailure()) {
            stringBuffer.append("OK");
        } else {
            stringBuffer.append("failed: ").append(this.failureCause);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toString() {
        return "RequestHandledEvent: " + this.getDescription();
    }
}

