/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class GenericWebApplicationContext
extends GenericApplicationContext
implements WebApplicationContext,
ThemeSource {
    private ServletContext servletContext;
    private ThemeSource themeSource;
    static /* synthetic */ Class class$org$springframework$web$context$ServletContextAware;

    public GenericWebApplicationContext() {
    }

    public GenericWebApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory) {
        super(defaultListableBeanFactory);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        configurableListableBeanFactory.registerScope("request", (Scope)new RequestScope());
        configurableListableBeanFactory.registerScope("session", (Scope)new SessionScope(false));
        configurableListableBeanFactory.registerScope("globalSession", (Scope)new SessionScope(true));
        configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext));
        configurableListableBeanFactory.ignoreDependencyInterface(class$org$springframework$web$context$ServletContextAware == null ? (class$org$springframework$web$context$ServletContextAware = GenericWebApplicationContext.class$("org.springframework.web.context.ServletContextAware")) : class$org$springframework$web$context$ServletContextAware);
    }

    protected Resource getResourceByPath(String string) {
        return new ServletContextResource(this.servletContext, string);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver((ResourceLoader)this);
    }

    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource((ApplicationContext)this);
    }

    public Theme getTheme(String string) {
        return this.themeSource.getTheme(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

