/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public abstract class AbstractRefreshableWebApplicationContext
extends AbstractRefreshableApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    private ServletContext servletContext;
    private ServletConfig servletConfig;
    private String namespace;
    private String[] configLocations;
    private ThemeSource themeSource;
    static /* synthetic */ Class class$org$springframework$web$context$ServletContextAware;
    static /* synthetic */ Class class$org$springframework$web$context$ServletConfigAware;

    public AbstractRefreshableWebApplicationContext() {
        this.setDisplayName("Root WebApplicationContext");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (servletConfig != null && this.servletContext == null) {
            this.servletContext = servletConfig.getServletContext();
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setNamespace(String string) {
        this.namespace = string;
        if (string != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + string + "'");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocations(String[] stringArray) {
        this.configLocations = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.configLocations[i] = this.resolvePath(stringArray[i]);
        }
    }

    public String[] getConfigLocations() {
        return this.configLocations != null ? this.configLocations : this.getDefaultConfigLocations();
    }

    protected String[] getDefaultConfigLocations() {
        return null;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        configurableListableBeanFactory.registerScope("request", (Scope)new RequestScope());
        configurableListableBeanFactory.registerScope("session", (Scope)new SessionScope(false));
        configurableListableBeanFactory.registerScope("globalSession", (Scope)new SessionScope(true));
        configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext, this.servletConfig));
        configurableListableBeanFactory.ignoreDependencyInterface(class$org$springframework$web$context$ServletContextAware == null ? (class$org$springframework$web$context$ServletContextAware = AbstractRefreshableWebApplicationContext.class$("org.springframework.web.context.ServletContextAware")) : class$org$springframework$web$context$ServletContextAware);
        configurableListableBeanFactory.ignoreDependencyInterface(class$org$springframework$web$context$ServletConfigAware == null ? (class$org$springframework$web$context$ServletConfigAware = AbstractRefreshableWebApplicationContext.class$("org.springframework.web.context.ServletConfigAware")) : class$org$springframework$web$context$ServletConfigAware);
    }

    protected String resolvePath(String string) {
        return SystemPropertyUtils.resolvePlaceholders((String)string);
    }

    protected Resource getResourceByPath(String string) {
        return new ServletContextResource(this.servletContext, string);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver((ResourceLoader)this);
    }

    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource((ApplicationContext)this);
    }

    public Theme getTheme(String string) {
        return this.themeSource.getTheme(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

