/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.util.WebUtils;

public class ServletRequestAttributes
extends AbstractRequestAttributes {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = (class$org$springframework$web$context$request$ServletRequestAttributes == null ? (class$org$springframework$web$context$request$ServletRequestAttributes = ServletRequestAttributes.class$("org.springframework.web.context.request.ServletRequestAttributes")) : class$org$springframework$web$context$request$ServletRequestAttributes).getName() + ".DESTRUCTION_CALLBACK.";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$context$request$ServletRequestAttributes == null ? (class$org$springframework$web$context$request$ServletRequestAttributes = ServletRequestAttributes.class$("org.springframework.web.context.request.ServletRequestAttributes")) : class$org$springframework$web$context$request$ServletRequestAttributes));
    private static final boolean bindingListenerAvailable = ClassUtils.isPresent((String)"javax.servlet.http.HttpSessionBindingListener", (ClassLoader)(class$org$springframework$web$context$request$ServletRequestAttributes == null ? (class$org$springframework$web$context$request$ServletRequestAttributes = ServletRequestAttributes.class$("org.springframework.web.context.request.ServletRequestAttributes")) : class$org$springframework$web$context$request$ServletRequestAttributes).getClassLoader());
    private final HttpServletRequest request;
    private HttpSession session;
    private final Map sessionAttributesToUpdate = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$context$request$ServletRequestAttributes;

    public ServletRequestAttributes(HttpServletRequest httpServletRequest) {
        Assert.notNull((Object)httpServletRequest, (String)"Request must not be null");
        this.request = httpServletRequest;
        this.session = httpServletRequest.getSession(false);
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    protected final HttpSession getSession(boolean bl) {
        try {
            this.session = this.request.getSession(bl);
            return this.session;
        }
        catch (IllegalStateException illegalStateException) {
            if (this.session == null) {
                throw illegalStateException;
            }
            if (bl) {
                boolean bl2 = false;
                try {
                    this.session = this.request.getSession(false);
                    bl2 = true;
                }
                catch (IllegalStateException illegalStateException2) {
                    // empty catch block
                }
                if (bl2) {
                    throw illegalStateException;
                }
            }
            return this.session;
        }
    }

    public Object getAttribute(String string, int n) {
        if (n == 0) {
            return this.request.getAttribute(string);
        }
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            Object object = httpSession.getAttribute(string);
            if (object != null) {
                this.sessionAttributesToUpdate.put(string, object);
            }
            return object;
        }
        return null;
    }

    public void setAttribute(String string, Object object, int n) {
        if (n == 0) {
            this.request.setAttribute(string, object);
        } else {
            HttpSession httpSession = this.getSession(true);
            httpSession.setAttribute(string, object);
            this.sessionAttributesToUpdate.remove(string);
        }
    }

    public void removeAttribute(String string, int n) {
        if (n == 0) {
            this.request.removeAttribute(string);
            this.removeRequestDestructionCallback(string);
        } else {
            HttpSession httpSession = this.getSession(false);
            if (httpSession != null) {
                httpSession.removeAttribute(string);
                this.sessionAttributesToUpdate.remove(string);
                httpSession.removeAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + string);
            }
        }
    }

    public void registerDestructionCallback(String string, Runnable runnable, int n) {
        if (n == 0) {
            this.registerRequestDestructionCallback(string, runnable);
        } else {
            this.registerSessionDestructionCallback(string, runnable);
        }
    }

    public String getSessionId() {
        return this.getSession(true).getId();
    }

    public Object getSessionMutex() {
        return WebUtils.getSessionMutex(this.getSession(true));
    }

    protected void updateAccessedSessionAttributes() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            Iterator iterator = this.sessionAttributesToUpdate.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                Object object = httpSession.getAttribute(string);
                if (object != v) continue;
                httpSession.setAttribute(string, v);
            }
        }
        this.sessionAttributesToUpdate.clear();
    }

    private void registerSessionDestructionCallback(String string, Runnable runnable) {
        if (bindingListenerAvailable) {
            HttpSession httpSession = this.getSession(true);
            httpSession.setAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + string, (Object)new DestructionCallbackBindingListener(runnable));
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Could not register destruction callback [" + runnable + "] for attribute '" + string + "' in session scope because Servlet 2.3 API is not available"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class DestructionCallbackBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private final Runnable destructionCallback;

        public DestructionCallbackBindingListener(Runnable runnable) {
            this.destructionCallback = runnable;
        }

        public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        }

        public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
            this.destructionCallback.run();
        }
    }
}

