/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.util.Locale;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestContextListener
implements ServletRequestListener {
    private static final String REQUEST_ATTRIBUTES_ATTRIBUTE = (class$org$springframework$web$context$request$RequestContextListener == null ? (class$org$springframework$web$context$request$RequestContextListener = RequestContextListener.class$("org.springframework.web.context.request.RequestContextListener")) : class$org$springframework$web$context$request$RequestContextListener).getName() + ".REQUEST_ATTRIBUTES";
    protected final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$web$context$request$RequestContextListener;

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        if (!(servletRequestEvent.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HttpServletRequest: " + servletRequestEvent.getServletRequest());
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequestEvent.getServletRequest();
        ServletRequestAttributes servletRequestAttributes = new ServletRequestAttributes(httpServletRequest);
        httpServletRequest.setAttribute(REQUEST_ATTRIBUTES_ATTRIBUTE, (Object)servletRequestAttributes);
        LocaleContextHolder.setLocale((Locale)httpServletRequest.getLocale());
        RequestContextHolder.setRequestAttributes(servletRequestAttributes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bound request context to thread: " + httpServletRequest));
        }
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)servletRequestEvent.getServletRequest().getAttribute(REQUEST_ATTRIBUTES_ATTRIBUTE);
        ServletRequestAttributes servletRequestAttributes2 = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes2 != null) {
            if (servletRequestAttributes == null) {
                servletRequestAttributes = servletRequestAttributes2;
            }
            RequestContextHolder.setRequestAttributes(null);
            LocaleContextHolder.setLocale(null);
        }
        if (servletRequestAttributes != null) {
            servletRequestAttributes.requestCompleted();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleared thread-bound request context: " + servletRequestEvent.getServletRequest()));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

