/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import org.springframework.web.context.request.RequestAttributes;

public abstract class RequestContextHolder {
    private static final ThreadLocal requestAttributesHolder = new ThreadLocal();
    private static final ThreadLocal inheritableRequestAttributesHolder = new InheritableThreadLocal();

    public static void resetRequestAttributes() {
        requestAttributesHolder.set(null);
        inheritableRequestAttributesHolder.set(null);
    }

    public static void setRequestAttributes(RequestAttributes requestAttributes) {
        RequestContextHolder.setRequestAttributes(requestAttributes, false);
    }

    public static void setRequestAttributes(RequestAttributes requestAttributes, boolean bl) {
        if (bl) {
            inheritableRequestAttributesHolder.set(requestAttributes);
            requestAttributesHolder.set(null);
        } else {
            requestAttributesHolder.set(requestAttributes);
            inheritableRequestAttributesHolder.set(null);
        }
    }

    public static RequestAttributes getRequestAttributes() {
        RequestAttributes requestAttributes = (RequestAttributes)requestAttributesHolder.get();
        if (requestAttributes == null) {
            requestAttributes = (RequestAttributes)inheritableRequestAttributesHolder.get();
        }
        return requestAttributes;
    }

    public static RequestAttributes currentRequestAttributes() throws IllegalStateException {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new IllegalStateException("No thread-bound request found: Are you referring to request attributes outside of an actual web request? If you are actually operating within a web request and still receive this message,your code is probably running outside of DispatcherServlet/DispatcherPortlet: In this case, use RequestContextListener or RequestContextFilter to expose the current request.");
        }
        return requestAttributes;
    }
}

