/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.util.Iterator;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;

public abstract class AbstractRequestAttributes
implements RequestAttributes {
    protected final Map requestDestructionCallbacks = CollectionFactory.createLinkedMapIfPossible((int)8);

    public void requestCompleted() {
        this.executeRequestDestructionCallbacks();
        this.updateAccessedSessionAttributes();
    }

    protected final void registerRequestDestructionCallback(String string, Runnable runnable) {
        Assert.notNull((Object)string, (String)"Name must not be null");
        Assert.notNull((Object)runnable, (String)"Callback must not be null");
        this.requestDestructionCallbacks.put(string, runnable);
    }

    protected final void removeRequestDestructionCallback(String string) {
        Assert.notNull((Object)string, (String)"Name must not be null");
        this.requestDestructionCallbacks.remove(string);
    }

    private void executeRequestDestructionCallbacks() {
        Iterator iterator = this.requestDestructionCallbacks.values().iterator();
        while (iterator.hasNext()) {
            ((Runnable)iterator.next()).run();
        }
        this.requestDestructionCallbacks.clear();
    }

    protected abstract void updateAccessedSessionAttributes();
}

