/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ContextLoader {
    public static final String CONTEXT_CLASS_PARAM = "contextClass";
    public static final String CONFIG_LOCATION_PARAM = "contextConfigLocation";
    public static final String LOCATOR_FACTORY_SELECTOR_PARAM = "locatorFactorySelector";
    public static final String LOCATOR_FACTORY_KEY_PARAM = "parentContextKey";
    private static final String DEFAULT_STRATEGIES_PATH = "ContextLoader.properties";
    private static final Properties defaultStrategies;
    private final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$context$ContextLoader == null ? (class$org$springframework$web$context$ContextLoader = ContextLoader.class$("org.springframework.web.context.ContextLoader")) : class$org$springframework$web$context$ContextLoader));
    private WebApplicationContext context;
    private BeanFactoryReference parentContextRef;
    static /* synthetic */ Class class$org$springframework$web$context$ContextLoader;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$WebApplicationContext;

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws IllegalStateException, BeansException {
        if (servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE) != null) {
            throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ContextLoader* definitions in your web.xml!");
        }
        servletContext.log("Initializing Spring root WebApplicationContext");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Root WebApplicationContext: initialization started");
        }
        long l = System.currentTimeMillis();
        try {
            ApplicationContext applicationContext = this.loadParentContext(servletContext);
            this.context = this.createWebApplicationContext(servletContext, applicationContext);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.context);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Published root WebApplicationContext as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
            }
            if (this.logger.isInfoEnabled()) {
                long l2 = System.currentTimeMillis() - l;
                this.logger.info((Object)("Root WebApplicationContext: initialization completed in " + l2 + " ms"));
            }
            return this.context;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error((Object)"Context initialization failed", (Throwable)runtimeException);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            this.logger.error((Object)"Context initialization failed", (Throwable)error);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)error);
            throw error;
        }
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext, ApplicationContext applicationContext) throws BeansException {
        Class clazz;
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoader.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(clazz = this.determineContextClass(servletContext))) {
            throw new ApplicationContextException("Custom context class [" + clazz.getName() + "] is not of type [" + (class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoader.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).getName() + "]");
        }
        ConfigurableWebApplicationContext configurableWebApplicationContext = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)clazz);
        configurableWebApplicationContext.setParent(applicationContext);
        configurableWebApplicationContext.setServletContext(servletContext);
        String string = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (string != null) {
            configurableWebApplicationContext.setConfigLocations(StringUtils.tokenizeToStringArray((String)string, (String)",; \t\n"));
        }
        configurableWebApplicationContext.refresh();
        return configurableWebApplicationContext;
    }

    protected Class determineContextClass(ServletContext servletContext) throws ApplicationContextException {
        String string = servletContext.getInitParameter(CONTEXT_CLASS_PARAM);
        if (string != null) {
            try {
                return ClassUtils.forName((String)string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ApplicationContextException("Failed to load custom context class [" + string + "]", (Throwable)classNotFoundException);
            }
        }
        string = defaultStrategies.getProperty((class$org$springframework$web$context$WebApplicationContext == null ? (class$org$springframework$web$context$WebApplicationContext = ContextLoader.class$("org.springframework.web.context.WebApplicationContext")) : class$org$springframework$web$context$WebApplicationContext).getName());
        try {
            return ClassUtils.forName((String)string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ApplicationContextException("Failed to load default context class [" + string + "]", (Throwable)classNotFoundException);
        }
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ApplicationContext applicationContext = null;
        String string = servletContext.getInitParameter(LOCATOR_FACTORY_SELECTOR_PARAM);
        String string2 = servletContext.getInitParameter(LOCATOR_FACTORY_KEY_PARAM);
        if (string2 != null) {
            BeanFactoryLocator beanFactoryLocator = ContextSingletonBeanFactoryLocator.getInstance((String)string);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting parent context definition: using parent context key of '" + string2 + "' with BeanFactoryLocator"));
            }
            this.parentContextRef = beanFactoryLocator.useBeanFactory(string2);
            applicationContext = (ApplicationContext)this.parentContextRef.getFactory();
        }
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWebApplicationContext(ServletContext servletContext) {
        servletContext.log("Closing Spring root WebApplicationContext");
        try {
            if (this.context instanceof ConfigurableWebApplicationContext) {
                ((ConfigurableWebApplicationContext)this.context).close();
            }
        }
        finally {
            if (this.parentContextRef != null) {
                this.parentContextRef.release();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            ClassPathResource classPathResource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, class$org$springframework$web$context$ContextLoader == null ? (class$org$springframework$web$context$ContextLoader = ContextLoader.class$("org.springframework.web.context.ContextLoader")) : class$org$springframework$web$context$ContextLoader);
            defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)classPathResource);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not load 'ContextLoader.properties': " + iOException.getMessage());
        }
    }
}

