/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.MultipartFile;

public class WebDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    private String fieldMarkerPrefix = "_";
    private boolean bindEmptyMultipartFiles = true;
    static /* synthetic */ Class class$java$lang$Boolean;

    public WebDataBinder(Object object) {
        super(object);
    }

    public WebDataBinder(Object object, String string) {
        super(object, string);
    }

    public void setFieldMarkerPrefix(String string) {
        this.fieldMarkerPrefix = string;
    }

    public String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bl) {
        this.bindEmptyMultipartFiles = bl;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    protected void doBind(MutablePropertyValues mutablePropertyValues) {
        this.checkFieldMarkers(mutablePropertyValues);
        super.doBind(mutablePropertyValues);
    }

    protected void checkFieldMarkers(MutablePropertyValues mutablePropertyValues) {
        if (this.getFieldMarkerPrefix() != null) {
            String string = this.getFieldMarkerPrefix();
            PropertyValue[] propertyValueArray = mutablePropertyValues.getPropertyValues();
            for (int i = 0; i < propertyValueArray.length; ++i) {
                PropertyValue propertyValue = propertyValueArray[i];
                if (!propertyValue.getName().startsWith(string)) continue;
                String string2 = propertyValue.getName().substring(string.length());
                if (this.getPropertyAccessor().isWritableProperty(string2) && !mutablePropertyValues.contains(string2)) {
                    Class clazz = this.getPropertyAccessor().getPropertyType(string2);
                    mutablePropertyValues.addPropertyValue(string2, this.getEmptyValue(string2, clazz));
                }
                mutablePropertyValues.removePropertyValue(propertyValue);
            }
        }
    }

    protected Object getEmptyValue(String string, Class clazz) {
        if (clazz != null && Boolean.TYPE.equals(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = WebDataBinder.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(clazz)) {
            return Boolean.FALSE;
        }
        if (clazz != null && clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 0);
        }
        return null;
    }

    protected void bindMultipartFiles(Map map, MutablePropertyValues mutablePropertyValues) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            MultipartFile multipartFile = (MultipartFile)entry.getValue();
            if (!this.isBindEmptyMultipartFiles() && multipartFile.isEmpty()) continue;
            mutablePropertyValues.addPropertyValue(string, (Object)multipartFile);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

