/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import javax.servlet.ServletRequest;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;

public abstract class ServletRequestUtils {
    private static final IntParser INT_PARSER = new IntParser();
    private static final LongParser LONG_PARSER = new LongParser();
    private static final FloatParser FLOAT_PARSER = new FloatParser();
    private static final DoubleParser DOUBLE_PARSER = new DoubleParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final StringParser STRING_PARSER = new StringParser();

    public static Integer getIntParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        if (servletRequest.getParameter(string) == null) {
            return null;
        }
        return new Integer(ServletRequestUtils.getRequiredIntParameter(servletRequest, string));
    }

    public static int getIntParameter(ServletRequest servletRequest, String string, int n) {
        if (servletRequest.getParameter(string) == null) {
            return n;
        }
        try {
            return ServletRequestUtils.getRequiredIntParameter(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return n;
        }
    }

    public static int[] getIntParameters(ServletRequest servletRequest, String string) {
        try {
            return ServletRequestUtils.getRequiredIntParameters(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return INT_PARSER.parseInt(string, servletRequest.getParameter(string));
    }

    public static int[] getRequiredIntParameters(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return INT_PARSER.parseInts(string, servletRequest.getParameterValues(string));
    }

    public static Long getLongParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        if (servletRequest.getParameter(string) == null) {
            return null;
        }
        return new Long(ServletRequestUtils.getRequiredLongParameter(servletRequest, string));
    }

    public static long getLongParameter(ServletRequest servletRequest, String string, long l) {
        if (servletRequest.getParameter(string) == null) {
            return l;
        }
        try {
            return ServletRequestUtils.getRequiredLongParameter(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return l;
        }
    }

    public static long[] getLongParameters(ServletRequest servletRequest, String string) {
        try {
            return ServletRequestUtils.getRequiredLongParameters(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return new long[0];
        }
    }

    public static long getRequiredLongParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return LONG_PARSER.parseLong(string, servletRequest.getParameter(string));
    }

    public static long[] getRequiredLongParameters(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return LONG_PARSER.parseLongs(string, servletRequest.getParameterValues(string));
    }

    public static Float getFloatParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        if (servletRequest.getParameter(string) == null) {
            return null;
        }
        return new Float(ServletRequestUtils.getRequiredFloatParameter(servletRequest, string));
    }

    public static float getFloatParameter(ServletRequest servletRequest, String string, float f) {
        if (servletRequest.getParameter(string) == null) {
            return f;
        }
        try {
            return ServletRequestUtils.getRequiredFloatParameter(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return f;
        }
    }

    public static float[] getFloatParameters(ServletRequest servletRequest, String string) {
        try {
            return ServletRequestUtils.getRequiredFloatParameters(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return new float[0];
        }
    }

    public static float getRequiredFloatParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return FLOAT_PARSER.parseFloat(string, servletRequest.getParameter(string));
    }

    public static float[] getRequiredFloatParameters(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return FLOAT_PARSER.parseFloats(string, servletRequest.getParameterValues(string));
    }

    public static Double getDoubleParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        if (servletRequest.getParameter(string) == null) {
            return null;
        }
        return new Double(ServletRequestUtils.getRequiredDoubleParameter(servletRequest, string));
    }

    public static double getDoubleParameter(ServletRequest servletRequest, String string, double d) {
        if (servletRequest.getParameter(string) == null) {
            return d;
        }
        try {
            return ServletRequestUtils.getRequiredDoubleParameter(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return d;
        }
    }

    public static double[] getDoubleParameters(ServletRequest servletRequest, String string) {
        try {
            return ServletRequestUtils.getRequiredDoubleParameters(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return new double[0];
        }
    }

    public static double getRequiredDoubleParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return DOUBLE_PARSER.parseDouble(string, servletRequest.getParameter(string));
    }

    public static double[] getRequiredDoubleParameters(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return DOUBLE_PARSER.parseDoubles(string, servletRequest.getParameterValues(string));
    }

    public static Boolean getBooleanParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        if (servletRequest.getParameter(string) == null) {
            return null;
        }
        return ServletRequestUtils.getRequiredBooleanParameter(servletRequest, string) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean getBooleanParameter(ServletRequest servletRequest, String string, boolean bl) {
        if (servletRequest.getParameter(string) == null) {
            return bl;
        }
        try {
            return ServletRequestUtils.getRequiredBooleanParameter(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return bl;
        }
    }

    public static boolean[] getBooleanParameters(ServletRequest servletRequest, String string) {
        try {
            return ServletRequestUtils.getRequiredBooleanParameters(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return BOOLEAN_PARSER.parseBoolean(string, servletRequest.getParameter(string));
    }

    public static boolean[] getRequiredBooleanParameters(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return BOOLEAN_PARSER.parseBooleans(string, servletRequest.getParameterValues(string));
    }

    public static String getStringParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        if (servletRequest.getParameter(string) == null) {
            return null;
        }
        return ServletRequestUtils.getRequiredStringParameter(servletRequest, string);
    }

    public static String getStringParameter(ServletRequest servletRequest, String string, String string2) {
        String string3 = servletRequest.getParameter(string);
        return string3 != null ? string3 : string2;
    }

    public static String[] getStringParameters(ServletRequest servletRequest, String string) {
        try {
            return ServletRequestUtils.getRequiredStringParameters(servletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return new String[0];
        }
    }

    public static String getRequiredStringParameter(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return STRING_PARSER.validateRequiredString(string, servletRequest.getParameter(string));
    }

    public static String[] getRequiredStringParameters(ServletRequest servletRequest, String string) throws ServletRequestBindingException {
        return STRING_PARSER.validateRequiredStrings(string, servletRequest.getParameterValues(string));
    }

    private static class BooleanParser
    extends ParameterParser {
        private BooleanParser() {
        }

        protected String getType() {
            return "boolean";
        }

        protected Object doParse(String string) throws NumberFormatException {
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("yes") || string.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        }

        public boolean parseBoolean(String string, String string2) throws ServletRequestBindingException {
            return (Boolean)this.parse(string, string2);
        }

        public boolean[] parseBooleans(String string, String[] stringArray) throws ServletRequestBindingException {
            this.validateRequiredParameter(string, stringArray);
            boolean[] blArray = new boolean[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                blArray[i] = this.parseBoolean(string, stringArray[i]);
            }
            return blArray;
        }
    }

    private static class DoubleParser
    extends ParameterParser {
        private DoubleParser() {
        }

        protected String getType() {
            return "double";
        }

        protected Object doParse(String string) throws NumberFormatException {
            return Double.valueOf(string);
        }

        public double parseDouble(String string, String string2) throws ServletRequestBindingException {
            return ((Number)this.parse(string, string2)).doubleValue();
        }

        public double[] parseDoubles(String string, String[] stringArray) throws ServletRequestBindingException {
            this.validateRequiredParameter(string, stringArray);
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i] = this.parseDouble(string, stringArray[i]);
            }
            return dArray;
        }
    }

    private static class FloatParser
    extends ParameterParser {
        private FloatParser() {
        }

        protected String getType() {
            return "float";
        }

        protected Object doParse(String string) throws NumberFormatException {
            return Float.valueOf(string);
        }

        public float parseFloat(String string, String string2) throws ServletRequestBindingException {
            return ((Number)this.parse(string, string2)).floatValue();
        }

        public float[] parseFloats(String string, String[] stringArray) throws ServletRequestBindingException {
            this.validateRequiredParameter(string, stringArray);
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = this.parseFloat(string, stringArray[i]);
            }
            return fArray;
        }
    }

    private static class IntParser
    extends ParameterParser {
        private IntParser() {
        }

        protected String getType() {
            return "int";
        }

        protected Object doParse(String string) throws NumberFormatException {
            return Integer.valueOf(string);
        }

        public int parseInt(String string, String string2) throws ServletRequestBindingException {
            return ((Number)this.parse(string, string2)).intValue();
        }

        public int[] parseInts(String string, String[] stringArray) throws ServletRequestBindingException {
            this.validateRequiredParameter(string, stringArray);
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this.parseInt(string, stringArray[i]);
            }
            return nArray;
        }
    }

    private static class LongParser
    extends ParameterParser {
        private LongParser() {
        }

        protected String getType() {
            return "long";
        }

        protected Object doParse(String string) throws NumberFormatException {
            return Long.valueOf(string);
        }

        public long parseLong(String string, String string2) throws ServletRequestBindingException {
            return ((Number)this.parse(string, string2)).longValue();
        }

        public long[] parseLongs(String string, String[] stringArray) throws ServletRequestBindingException {
            this.validateRequiredParameter(string, stringArray);
            long[] lArray = new long[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                lArray[i] = this.parseLong(string, stringArray[i]);
            }
            return lArray;
        }
    }

    private static abstract class ParameterParser {
        private ParameterParser() {
        }

        protected final Object parse(String string, String string2) throws ServletRequestBindingException {
            this.validateRequiredParameter(string, string2);
            try {
                return this.doParse(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServletRequestBindingException("Required " + this.getType() + " parameter '" + string + "' with value of '" + string2 + "' is not a valid number", numberFormatException);
            }
        }

        protected final void validateRequiredParameter(String string, Object object) throws ServletRequestBindingException {
            if (object == null) {
                throw new MissingServletRequestParameterException(string, this.getType());
            }
        }

        protected abstract String getType();

        protected abstract Object doParse(String var1) throws NumberFormatException;
    }

    private static class StringParser
    extends ParameterParser {
        private StringParser() {
        }

        protected String getType() {
            return "string";
        }

        protected Object doParse(String string) throws NumberFormatException {
            return string;
        }

        public String validateRequiredString(String string, String string2) throws ServletRequestBindingException {
            this.validateRequiredParameter(string, string2);
            return string2;
        }

        public String[] validateRequiredStrings(String string, String[] stringArray) throws ServletRequestBindingException {
            this.validateRequiredParameter(string, stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                this.validateRequiredParameter(string, stringArray[i]);
            }
            return stringArray;
        }
    }
}

