/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import javax.servlet.ServletRequest;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ServletRequestDataBinder
extends WebDataBinder {
    public ServletRequestDataBinder(Object object) {
        super(object);
    }

    public ServletRequestDataBinder(Object object, String string) {
        super(object, string);
    }

    public void bind(ServletRequest servletRequest) {
        ServletRequestParameterPropertyValues servletRequestParameterPropertyValues = new ServletRequestParameterPropertyValues(servletRequest);
        if (servletRequest instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)servletRequest;
            this.bindMultipartFiles(multipartHttpServletRequest.getFileMap(), servletRequestParameterPropertyValues);
        }
        this.doBind(servletRequestParameterPropertyValues);
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getBindingResult().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getBindingResult().getObjectName() + "'", (Throwable)new BindException(this.getBindingResult()));
        }
    }
}

