/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;

public abstract class RequestUtils {
    public static void rejectRequestMethod(HttpServletRequest httpServletRequest, String string) throws ServletException {
        if (httpServletRequest.getMethod().equals(string)) {
            throw new HttpRequestMethodNotSupportedException(string);
        }
    }

    public static Integer getIntParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getIntParameter((ServletRequest)httpServletRequest, string);
    }

    public static int getIntParameter(HttpServletRequest httpServletRequest, String string, int n) {
        return ServletRequestUtils.getIntParameter((ServletRequest)httpServletRequest, string, n);
    }

    public static int[] getIntParameters(HttpServletRequest httpServletRequest, String string) {
        return ServletRequestUtils.getIntParameters((ServletRequest)httpServletRequest, string);
    }

    public static int getRequiredIntParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredIntParameter((ServletRequest)httpServletRequest, string);
    }

    public static int[] getRequiredIntParameters(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredIntParameters((ServletRequest)httpServletRequest, string);
    }

    public static Long getLongParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getLongParameter((ServletRequest)httpServletRequest, string);
    }

    public static long getLongParameter(HttpServletRequest httpServletRequest, String string, long l) {
        return ServletRequestUtils.getLongParameter((ServletRequest)httpServletRequest, string, l);
    }

    public static long[] getLongParameters(HttpServletRequest httpServletRequest, String string) {
        return ServletRequestUtils.getLongParameters((ServletRequest)httpServletRequest, string);
    }

    public static long getRequiredLongParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredLongParameter((ServletRequest)httpServletRequest, string);
    }

    public static long[] getRequiredLongParameters(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredLongParameters((ServletRequest)httpServletRequest, string);
    }

    public static Float getFloatParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getFloatParameter((ServletRequest)httpServletRequest, string);
    }

    public static float getFloatParameter(HttpServletRequest httpServletRequest, String string, float f) {
        return ServletRequestUtils.getFloatParameter((ServletRequest)httpServletRequest, string, f);
    }

    public static float[] getFloatParameters(HttpServletRequest httpServletRequest, String string) {
        return ServletRequestUtils.getFloatParameters((ServletRequest)httpServletRequest, string);
    }

    public static float getRequiredFloatParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredFloatParameter((ServletRequest)httpServletRequest, string);
    }

    public static float[] getRequiredFloatParameters(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredFloatParameters((ServletRequest)httpServletRequest, string);
    }

    public static Double getDoubleParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getDoubleParameter((ServletRequest)httpServletRequest, string);
    }

    public static double getDoubleParameter(HttpServletRequest httpServletRequest, String string, double d) {
        return ServletRequestUtils.getDoubleParameter((ServletRequest)httpServletRequest, string, d);
    }

    public static double[] getDoubleParameters(HttpServletRequest httpServletRequest, String string) {
        return ServletRequestUtils.getDoubleParameters((ServletRequest)httpServletRequest, string);
    }

    public static double getRequiredDoubleParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredDoubleParameter((ServletRequest)httpServletRequest, string);
    }

    public static double[] getRequiredDoubleParameters(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredDoubleParameters((ServletRequest)httpServletRequest, string);
    }

    public static Boolean getBooleanParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        if (httpServletRequest.getParameter(string) == null) {
            return null;
        }
        return RequestUtils.getRequiredBooleanParameter(httpServletRequest, string) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean getBooleanParameter(HttpServletRequest httpServletRequest, String string, boolean bl) {
        if (httpServletRequest.getParameter(string) == null) {
            return bl;
        }
        try {
            return RequestUtils.getRequiredBooleanParameter(httpServletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return bl;
        }
    }

    public static boolean[] getBooleanParameters(HttpServletRequest httpServletRequest, String string) {
        try {
            return RequestUtils.getRequiredBooleanParameters(httpServletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        boolean bl = ServletRequestUtils.getRequiredBooleanParameter((ServletRequest)httpServletRequest, string);
        if (!bl && "".equals(httpServletRequest.getParameter(string))) {
            throw new ServletRequestBindingException("Required boolean parameter '" + string + "' contains no value");
        }
        return bl;
    }

    public static boolean[] getRequiredBooleanParameters(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        boolean[] blArray = ServletRequestUtils.getRequiredBooleanParameters((ServletRequest)httpServletRequest, string);
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] || !"".equals(httpServletRequest.getParameterValues(string)[i])) continue;
            throw new ServletRequestBindingException("Required boolean parameter '" + string + "' contains no value");
        }
        return blArray;
    }

    public static String getStringParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        if (httpServletRequest.getParameter(string) == null) {
            return null;
        }
        return RequestUtils.getRequiredStringParameter(httpServletRequest, string);
    }

    public static String getStringParameter(HttpServletRequest httpServletRequest, String string, String string2) {
        if (httpServletRequest.getParameter(string) == null) {
            return string2;
        }
        try {
            return RequestUtils.getRequiredStringParameter(httpServletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return string2;
        }
    }

    public static String[] getStringParameters(HttpServletRequest httpServletRequest, String string) {
        try {
            return RequestUtils.getRequiredStringParameters(httpServletRequest, string);
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return new String[0];
        }
    }

    public static String getRequiredStringParameter(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        String string2 = ServletRequestUtils.getRequiredStringParameter((ServletRequest)httpServletRequest, string);
        if ("".equals(string2)) {
            throw new ServletRequestBindingException("Required string parameter '" + string + "' contains no value");
        }
        return string2;
    }

    public static String[] getRequiredStringParameters(HttpServletRequest httpServletRequest, String string) throws ServletRequestBindingException {
        String[] stringArray = ServletRequestUtils.getRequiredStringParameters((ServletRequest)httpServletRequest, string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"".equals(stringArray[i])) continue;
            throw new ServletRequestBindingException("Required string parameter '" + string + "' contains no value");
        }
        return stringArray;
    }
}

